/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

.pragma library

/*
Phương Nam 	1.Giác 	2.Cang 	3.Đe 	        4.Phòng 	5.Tâm 	6.Vĩ 	        7.Cơ
Phương Đông 	8.Đẩu 	9.Ngưu 	10.Nữ 	11.Hư 	12.Nguy 	13.Thất 	14.Bích
Phương Bắc 	15.Khuê 	16.Lâu 	17.Vị 	18.Mão 	19.Tất 	20.Chuỷ 	21.Sâm
Phương Tây 	22.Tinh 	23.Quỷ 	24.Liễu 	25.Tinh 	26.Trương 	27.Lực 	28.Chẩn
Ngày tuần lễ 	Thứ Năm 	Thứ sáu 	Thứ bảy 	Chủ nhật 	Thứ hai 	Thứ ba 	Thứ tư
Thống thuộc
sao theo hệ
mặt trời 	          Mộc 	Kim 	         Thổ 	         Thái dươn  Thái âm 	 Hoả 	         Thuỷ
  */
var TUAN_SAO = new Array("Giác", "Cáng", "Đê", "Phòng", "Tâm", "Vĩ", "Cơ", "Đẩu", "Ngưu","Nữ","Hư","Nguy","Thất",
                         "Bích","Khuê","Lâu","Vị","Mão","Tất","Chủy","Sâm","Tinh","Quỷ","Liễu","Tinh","Trương","Lực","Chẩn");
var SAO_CON_VAT = new Array("Giao Long","Rồng","Lạc","Thỏ","Hồ","Hổ","Báo","Giải","Trâu","Dơi","Chuột","Én","Lợn",
                            "Du","Lang","Chó","Trĩ","Gà","Chim","Khỉ","Vượn","Hươu Bướu","Dê","Hoẵng","Ngựa","Hươu","Rắn","Giun");
var SAO_THUOC = new Array("Mộc","Kim","Thổ","Thái Dương","Thái Âm","Hoả","Thuỷ","Mộc","Kim","Thổ",
                          "Thái Dương","Thái Âm","Hoả","Thuỷ","Mộc","Kim","Thổ","Thái Dương","Thái Âm","Hoả","Thuỷ",
                          "Mộc","Kim","Thổ","Thái Dương","Thái Âm","Hoả","Thuỷ")

function sao(curYear, totalDays) {

    var t=5;//1900

    if (curYear > 1900){
        for (var j=1901;j<=curYear;j++){
            if (j % 4 == 0)
                    t+=2;
            else
                    t+=1
        }
    }

    while (t>28){
        t-=28;
    }
    var k = t+totalDays;
    while (k>28){
        k-=28;
    }

    return "Sao: <b>"+TUAN_SAO[k-1]+"</b> Thuộc: <b>"+SAO_THUOC[k-1]+"</b> Con vật: <b>"+SAO_CON_VAT[k-1]+"</b>"
}

var TRUC = new Array("Kiến", "Trừ","Mãn","Bình","Định","Chấp","Phá","Nguy","Thành","Thu","Khai","Bế");

var glTruc = -1;

var TRUC_TOT_XAU = new Array(
        "Tốt với xuất hành, giá thú.<br>Nhưng xấu với động thổ (vì trùng với Thổ phủ)",
        "Tốt nói chung",
        "Tốt với tế tự, cầu tài, cầu phú, xấu với các việc khác (vì trùng sao xấu)",
        "Tốt với mọi việc",
        "Tốt với cầu tài, ký hợp đồng, yến tiệc xấu với tố tụng, tranh chấp, chữa bệnh (vì có Đại hao, Quan phù)",
        "Tốt với khởi công xây dựng, xấu với xuất hành, di chuyển, khai trương",
        "Xấu với mọi việc, riêng chữa bệnh, dỡ nhà củ, phá bỏ đồ củ là tốt",
         "Mọi việc đều xấu",
        "Tốt với xuất hành, giá thú, khai trương. Xấu với kiện cáo, tranh chấp",
        "Thu hoạch tốt, kỵ khởi công, xuất hành, an táng",
        "Tốt mọi việc, trừ động thổ, an táng",
        "Xấu mọi việc, trừ đắp đê, lấp hố rãnh"
        );

var TRUC_THANG = new Array(
        new Array([3, 0],[4, 1],[5, 2],[6, 3],[7, 4],[8, 5],[9, 6],[10, 7],[11, 8],[12, 9],[1, 10],[2, 11]),//1
        new Array([4, 0],[5, 1],[6, 2],[7, 3],[8, 4],[9, 5],[10, 6],[11, 7],[12, 8],[1, 9],[2, 10],[3, 11]),//2
        new Array([5, 0],[6, 1],[7, 2],[8, 3],[9, 4],[10, 5],[11, 6],[12, 7],[1, 8],[2, 9],[3, 10],[4, 11]),//3
        new Array([6, 0],[7, 1],[8, 2],[9, 3],[10, 4],[11, 5],[12, 6],[1, 7],[2, 8],[3, 9],[4, 10],[5, 11]),//4
        new Array([7, 0],[8, 1],[9, 2],[10, 3],[11, 4],[12, 5],[1, 6],[2, 7],[3, 8],[4, 9],[5, 10],[6, 11]),//5
        new Array([8, 0],[9, 1],[10, 2],[11, 3],[12, 4],[1, 5],[2, 6],[3, 7],[4, 8],[5, 9],[6, 10],[7, 11]),//6
        new Array([9, 0],[10, 1],[11, 2],[12, 3],[1, 4],[2, 5],[3, 6],[4, 7],[5, 8],[6, 9],[7, 10],[8, 11]),//7
        new Array([10, 0],[11, 1],[12, 2],[1, 3],[2, 4],[3, 5],[4, 6],[5, 7],[6, 8],[7, 9],[8, 10],[9, 11]),//8
        new Array([11, 0],[12, 1],[1, 2],[2, 3],[3, 4],[4, 5],[5, 6],[6, 7],[7, 8],[8, 9],[9, 10],[10, 11]),//9
        new Array([12, 0],[1, 1],[2, 2],[3, 3],[4, 4],[5, 5],[6, 6],[7, 7],[8, 8],[9, 9],[10, 10],[11, 11]),//10
        new Array([1, 0],[2, 1],[3, 2],[4, 3],[5, 4],[6, 5],[7, 6],[8, 7],[9, 8],[10, 9],[11, 10],[12, 11]),//11
        new Array([2, 0],[3, 1],[4, 2],[5, 3],[6, 4],[7, 5],[8, 6],[9, 7],[10, 8],[11, 9],[12, 10],[1, 11])//12
        )

var HD = new Array(
        "Thanh Long Hoàng đạo",
        "Minh Đường Hoàng đạo",
        "Thiên Hình Hắc đạo",
        "Chu Tước Hắc đạo",
        "Kim Quỹ Hoàng đạo",
        "Bảo Quang(Kim Đường) Hoàng đạo",
        "Bạch Hổ Hắc đạo",
        "Ngọc Đường Hoàng đạo",
        "Thiên Lao Hắc đạo",
        "Nguyên Vũ Hắc đạo",
        "Tư Mệnh Hoàng đạo",
        "Câu Trận Hắc đạo"
        )

var HD_MATRIX = new Array(
        new Array([9, 0],[10, 1],[11, 2],[12, 3],[1, 4],[2, 5],[3, 6],[4, 7],[5, 8],[6, 9],[7, 10],[8, 11]),//1 Ty
        new Array([11, 0],[12, 1],[1, 2],[2, 3],[3, 4],[4, 5],[5, 6],[6, 7],[7, 8],[8, 9],[9, 10],[10, 11]),//2 Suu
        new Array([1, 0],[2, 1],[3, 2],[4, 3],[5, 4],[6, 5],[7, 6],[8, 7],[9, 8],[10, 9],[11, 10],[12, 11]),//3 Dan
        new Array([3, 0],[4, 1],[5, 2],[6, 3],[7, 4],[8, 5],[9, 6],[10, 7],[11, 8],[12, 9],[1, 10],[2, 11]),//4 Mao
        new Array([5, 0],[6, 1],[7, 2],[8, 3],[9, 4],[10, 5],[11, 6],[12, 7],[1, 8],[2, 9],[3, 10],[4, 11]),//5 Thin
        new Array([7, 0],[8, 1],[9, 2],[10, 3],[11, 4],[12, 5],[1, 6],[2, 7],[3, 8],[4, 9],[5, 10],[6, 11]),//6 Ty
        new Array([9, 0],[10, 1],[11, 2],[12, 3],[1, 4],[2, 5],[3, 6],[4, 7],[5, 8],[6, 9],[7, 10],[8, 11]),//7 Ngo
        new Array([11, 0],[12, 1],[1, 2],[2, 3],[3, 4],[4, 5],[5, 6],[6, 7],[7, 8],[8, 9],[9, 10],[10, 11]),//8 Mui
        new Array([1, 0],[2, 1],[3, 2],[4, 3],[5, 4],[6, 5],[7, 6],[8, 7],[9, 8],[10, 9],[11, 10],[12, 11]),//9 Than
        new Array([3, 0],[4, 1],[5, 2],[6, 3],[7, 4],[8, 5],[9, 6],[10, 7],[11, 8],[12, 9],[1, 10],[2, 11]),//10 Dau
        new Array([5, 0],[6, 1],[7, 2],[8, 3],[9, 4],[10, 5],[11, 6],[12, 7],[1, 8],[2, 9],[3, 10],[4, 11]),//11 Tuat
        new Array([7, 0],[8, 1],[9, 2],[10, 3],[11, 4],[12, 5],[1, 6],[2, 7],[3, 8],[4, 9],[5, 10],[6, 11])//12 Hoi


        )


function truc(lunarMonth, lunarDayCanChi, lunarMonthCanChi){
    var CHI = lunarDayCanChi.split(" ")[1];
    var MCHI = lunarMonthCanChi.split(" ")[1];

    var chi_so_gia;

    switch(CHI){
    case "Tý": chi_so_gia=1; break;
    case "Sửu":  chi_so_gia=2; break;
    case "Dần": chi_so_gia=3; break;
    case "Mão":  chi_so_gia=4; break;
    case "Thìn": chi_so_gia=5; break;
    case "Tỵ": chi_so_gia=6; break;
    case "Ngọ":  chi_so_gia=7; break;
    case "Mùi":  chi_so_gia=8; break;
    case "Thân":  chi_so_gia=9; break;
    case "Dậu":  chi_so_gia=10; break;
    case "Tuất":  chi_so_gia=11; break;
    case "Hợi":  chi_so_gia=12; break;
    }

    var getTrucofMonth = TRUC_THANG[lunarMonth-1];
    var txtTruc="";

    for (var i=0;i<12;i++)
        if (getTrucofMonth[i][0]==chi_so_gia){
            txtTruc = TRUC[getTrucofMonth[i][1]];
            glTruc = getTrucofMonth[i][1];
            break;
        }

   var chi_so_giaM;

    switch(MCHI){
    case "Tý": chi_so_giaM=1; break;
    case "Sửu":  chi_so_giaM=2; break;
    case "Dần": chi_so_giaM=3; break;
    case "Mão":  chi_so_giaM=4; break;
    case "Thìn": chi_so_giaM=5; break;
    case "Tỵ": chi_so_giaM=6; break;
    case "Ngọ":  chi_so_giaM=7; break;
    case "Mùi":  chi_so_giaM=8; break;
    case "Thân":  chi_so_giaM=9; break;
    case "Dậu":  chi_so_giaM=10; break;
    case "Tuất":  chi_so_giaM=11; break;
    case "Hợi":  chi_so_giaM=12; break;
    }

    var txtLangay = "";

   for(i=0;i<12;i++)
       if (HD_MATRIX[chi_so_giaM-1][i][0] == chi_so_gia){
           txtLangay=HD[HD_MATRIX[chi_so_giaM-1][i][1]];
           break;
       }

    return "Là ngày: <b>"+txtLangay+"</b>, Trực: <b>"+txtTruc+"</b>";
}


function luangiai(curDay){
    /*if (glTruc != -1){
        return TRUC_TOT_XAU[glTruc];
    }*/
    return "Tốt đối với:<br>Hơi tốt:<br>Hạn chế làm:<br>Không nên:<br>";
}

var SAO_TOT_TEN = new Array(
        "Thiên đức",
        "Thiên đức hợp",
        "Nguyệt Đức",
        "Nguyệt đức hợp",
        "Thiên hỷ",
        "Thiên phú",
        "Thiên Quý",
        "Thiên Xá",
        "Sinh khí",
        "Thiên Phúc",
        "Thiên thành",
        "Thiên Quan",
        "Thiên Mã",
        "Thiên tài",
        "Địa tài",
        "Nguyệt Tài",
        "Nguyệt Ân",
        "Nguyệt Không",
        "Minh tinh",
        "Thánh tâm",
        "Ngũ phú",
        "Lộc khố",
        "Phúc Sinh",
        "Cát Khánh",
        "Âm Đức",
        "U Vi tinh",
        "Mãn đức tinh",
        "Kính Tâm",
        "Tuế hợp",
        "Nguyệt giải",
        "Quan nhật",
        "Hoạt điệu",
        "Giải thần",
        "Phổ hộ",
        "Ích Hậu",
        "Tục Thế",
        "Yếu yên",
        "Dịch Mã",
        "Tam Hợp",
        "Lục Hợp",
       "Mẫu Thương",
        "Phúc hậu",
        "Đại Hồng Sa",
        "Dân nhật, thời đức",
        "Hoàng Ân",
        "Thanh Long",
        "Minh đường",
        "Kim đường",
        "Ngọc đường"
            );

var SAO_TOT_MATRIX = new Array(
                                new Array(
            "Đinh",
            "Nhâm",
            "Bính",
            "Tân",
            "Tuất",
            "Thìn",
            "Giáp Ất",
            "Mậu Dần",
            "Tý",
            "Kỷ",
            "Mùi",
            "Tuất",
            "Ngọ",
            "Thìn",
            "Tỵ",
            "Ngọ",
            "Bính",
            "Nhâm",
            "Thân",
            "Hợi",
            "Hợi",
            "Thìn",
            "Dậu",
            "Dậu",
            "Dậu",
            "Hợi",
            "Dần",
            "Mùi",
            "Sửu",
            "Thân",
            " -",
            "Tỵ",
            "Thân",
            "Thân",
            "Tý",
            "Sửu",
            "Dần",
            "Thân",
            "Ngọ Tuất",
            "Hợi",
            "Hợi Tý",
            "Dần",
            "Tý Sửu",
            "Ngọ",
            "Tuất",
            "Tý",
            "Sửu",
            "Tỵ",
            "Mùi"
            ),//1
                                new Array(
            "Thân",
            "Tý",
            "Giáp",
            "Kỷ",
            "Hợi",
            "Tỵ",
            "Giáp Ất",
            "Mậu Dần",
            "Sửu",
            "Mậu",
            "Dậu",
            "Tý",
            "Thân",
            "Ngọ",
            "Mùi",
            "Tỵ",
            "Đinh",
            "Canh",
            "Tuất",
            "Tỵ",
            "Dần",
            "Tỵ",
            "Mão",
            "Dần",
            "Mùi",
            "Thìn",
            "Mùi",
            "Sửu",
            "Tý",
            "Thân",
            "Mão",
            "Tuất",
            "Thân",
            "Dần",
            "Ngọ",
            "Mùi",
            "Thân",
            "Tỵ",
            "Mùi Hợi",
            "Tuất",
            "Hợi Tý",
            "Dần",
            "Tý Sửu",
            "Ngọ",
            "Sửu",
            "Dần",
            "Mão",
            "Mùi",
            "Dậu"
            ),//2
                                new Array(//3
            "Nhâm",
            "Đinh",
            "Nhâm",
            "Đinh",
            "Tý",
            "Ngọ",
            "Giáp Ất",
            "Mậu Dần",
            "Dần",
            "-",
            "Hợi",
            "Dần",
            "Tuất",
            "Thân",
            "Dậu",
            "Tỵ",
            "Canh",
            "Bính",
            "Tý",
            "Tý",
            "Tỵ",
            "Ngọ",
            "Tuất",
            "Hợi",
            "Tỵ",
            "Sửu",
            "Thìn",
            "Thân",
            "Hợi",
            "Dậu",
            "-",
            "Mùi",
            "Tuất",
            "Dậu",
            "Sửu",
            "Dần",
            "Mão",
            "Dần",
            "Thân Tý",
            "Dậu",
            "Hợi Tý",
            "Dần",
            "Tý Sửu",
            "Ngọ",
            "Dần",
            "Thìn",
            "Tỵ",
            "Dậu",
            "Hợi"
                                ),
                                new Array(
            "Tân",
            "Bính",
            "Canh",
            "Ất",
            "Sửu",
            "Mùi",
            "Bính Đinh",
            "Giáp Ngọ",
            "Mão",
            "Tân Quý",
            "Sửu",
            "Thìn",
            "Tý",
            "Tuất",
            "Hợi",
            "Mùi",
            "Kỷ",
            "Giáp",
            "Dần",
            "Ngọ",
            "Thân",
            "Mùi",
            "Thìn",
            "Thìn",
            "Mão",
            "Ngọ",
            "Dậu",
            "Dần",
            "Tuất",
            "Dậu",
            " -",
            "Tý",
            "Tuất",
            "Mão",
            "Mùi",
            "Thân",
            "Dậu",
            "Hợi",
            "Dậu Sửu",
            "Thân",
            "Dần Mão",
            "Tỵ",
            "Thìn Tỵ",
            "Dậu",
            "Tỵ",
            "Ngọ",
            "Mùi",
            "Hợi",
            "Sửu"
            ),//4
                                new Array(
            "Hợi",
            "Dần",
            "Bính",
            "Tân",
            "Dần",
            "Thân",
            "Bính Đinh",
            " -",
            "Thìn",
            "Tân Nhâm",
            "Mão",
            "Ngọ",
            "Dần",
            "Tý",
            "Sửu",
            "Dậu",
            "Mậu",
            "Nhâm",
            "Thìn",
            "Sửu",
            "Hợi",
            "Thân",
            "Hợi",
            "Sửu",
            "Sửu",
            "Mão",
            "Ngọ",
            "Dậu",
            "Dậu",
            "Tuất",
            "Ngọ",
            "Dậu",
            "Tý",
            "Tuất",
            "Dần",
            "Mão",
            "Thìn",
            "Thân",
            "Tuất Dần",
            "Mùi",
            "Dần Mão",
            "Tỵ",
            "Thìn Tỵ",
            "Dậu",
            "Dậu",
            "Thân",
            "Dậu",
            "Sửu",
            "Mão"
            ),//5
                                new Array(
            "Giáp",
            "Kỷ",
            "Giáp",
            "Kỷ",
            "Mão",
            "Dậu",
            "Bính Đinh",
            "Giáp Ngọ",
            "Tỵ",
            " ",
            "Tỵ",
            "Thân",
            "Thìn",
            "Dần",
            "Mão",
            "Hợi",
            "Tân",
            "Canh",
            "Ngọ",
            "Mùi",
            "Dần",
            "Dậu",
            "Tỵ",
            "Ngọ",
            "Hợi",
            "Thân",
            "Hợi",
            "Mão",
            "Thân",
            "Tuất",
            " -",
            "Dần",
            "Tý",
            "Thìn",
            "Thân",
            "Dậu",
            "Tuất",
            "Tỵ",
            "Hợi Mão",
            "Ngọ",
            "Dần Mão",
            "Tỵ",
            "Thìn Tỵ",
            "Dậu",
            "Mão",
            "Tuất",
            "Hợi",
            "Mão",
            "Tỵ"
            ),//6
                                new Array(//7
                                          "Quý",
                                          "Mậu",
                                          "Nhâm",
                                          "Đinh",
                                          "Thìn",
                                          "Tuất",
                                          "Canh Tân",
                                          "Mậu Thân",
                                          "Ngọ",
                                          "Ất",
                                          "Mùi",
                                          "Tuất",
                                          "Ngọ",
                                          "Thìn",
                                          "Tỵ",
                                          "Ngọ",
                                          "Nhâm",
                                          "Bính",
                                          "Thân",
                                          "Dần",
                                          "Tỵ",
                                          "Tuất",
                                          "Tý",
                                          "Mão",
                                          "Dậu",
                                          "Tỵ",
                                          "Thân",
                                          "Tuất",
                                          "Mùi",
                                          "Hợi",
                                          " -",
                                          "Hợi",
                                          "Dần",
                                          "Hợi",
                                          "Mão",
                                          "Thìn",
                                          "Tỵ",
                                          "Dần",
                                          "Tý Thìn",
                                          "Tỵ",
                                          "Thìn Sửu",
                                          "Thân",
                                          "Ngọ Mùi",
                                          "Tý",
                                          "Tý",
                                          "Tý",
                                          "Sửu",
                                          "Tỵ",
                                          "Mùi"
            ),
                                new Array(
            "Dần",
            "Hợi",
            "Canh",
            "Ất",
            "Tỵ",
            "Hợi",
            "Canh Tân",
            "Mậu  Thân",
            "Mùi",
            "Giáp",
            "Dậu",
            "Tý",
            "Thân",
            "Ngọ",
            "Mùi",
            "Tỵ",
            "Quý",
            "Giáp",
            "Tuất",
            "Thân",
            "Thân",
            "Hợi",
            "Ngọ",
            "Thân",
            "Mùi",
            "Tuất",
            "Sửu",
            "Thìn",
            "Ngọ",
            "Hợi",
            "Dậu",
            "Thìn",
            "Dần",
            "Tỵ",
            "Dậu",
            "Tuất",
            "Hợi",
            "Hợi",
            "Sửu Tỵ",
            "Thìn",
            "Thìn Sửu",
            "Thân",
            "Ngọ Mùi",
            "Tý",
            "Ngọ",
            "Dần",
            "Mão",
            "Mùi",
            "Dậu"
            ),//8
                                new Array(
            "Bính",
            "Tân",
            "Bính",
            "Tân",
            "Ngọ",
            "Tý",
            "Canh Tân",
            "Mậu Thân",
            "Thân",
            "-",
            "Hợi",
            "Dần",
            "Tuất",
            "Thân",
            "Dậu",
            "Tỵ",
            "Canh",
            "Nhâm",
            "Tý",
            "Mão",
            "Hợi",
            "Tý",
            "Sửu",
            "Tỵ",
            "Tỵ",
            "Mùi",
            "Tuất",
            "Hợi",
            "Tỵ",
            "Ngọ",
            " -",
            "Sửu",
            "Thìn",
            "Tý",
            "Thìn",
            "Tỵ",
            "Ngọ",
            "Thân",
            "Dần Ngọ",
            "Mão",
            "Thìn Sửu",
            "Thân",
            "Ngọ Mùi",
            "Tý",
            "Hợi",
            "Thìn",
            "Tỵ",
            "Dậu",
            "Hợi"
            ),//9
                                new Array(
            "Ất",
            "Canh",
            "Giáp",
            "Kỷ",
            "Mùi",
            "Sửu",
            "Nhâm Quý",
            "Giáp Tý",
            "Dậu",
            "Đinh",
            "Sửu",
            "Thìn",
            "Tý",
            "Tuất",
            "Hợi",
            "Mùi",
            "Ất",
            "Canh",
            "Dần",
            "Dậu",
            "Dần",
            "Sửu",
            "Mùi",
            "Tuất",
            "Mão",
            "Tý",
            "Mão",
            "Tỵ",
            "Thìn",
            "Ngọ",
            "-",
            "Ngọ",
            "Thìn",
            "Ngọ",
            "Tuất",
            "Hợi",
            "Tý",
            "Tỵ",
            "Mão Mùi",
            "Dần",
            "Thân Dậu",
            "Hợi",
            "Thân Tuất",
            "Mão",
            "Thìn",
            "Ngọ",
            "Mùi",
            "Hợi",
            "Sửu"
            ),//10
                                new Array(
            "Tỵ",
            "Thân",
            "Nhâm",
            "Đinh",
            "Thân",
            "Dần",
            "Nhâm Quý",
            "-",
            "Tuất",
            "Bính",
            "Mão",
            "Ngọ",
            "Dần",
            "Tý",
            "Sửu",
            "Dậu",
            "Giáp",
            "Bính",
            "Thìn",
            "Thìn",
            "Tỵ",
            "Dần",
            "Dần",
            "Mùi",
            "Sửu",
            "Dậu",
            "Tý",
            "Tý",
            "Mão",
            "Mùi",
            "Tý",
            "Mão",
            "Ngọ",
            "Sửu",
            "Tỵ",
            "Ngọ",
            "Mùi",
            "Dần",
            "Thìn Thân",
            "Sửu",
            "Thân Dậu",
            "Hợi",
            "Thân Tuất",
            "Mão",
            "Thân",
            "Thân",
            "Dậu",
            "Sửu",
            "Mão"
            ),//11
                                new Array(
            "Canh",
            "Ất",
            "Canh",
            "Ất",
            "Dậu",
            "Mão",
            "Nhâm Quý",
            "Giáp  Tý",
            "Hợi",
            "-",
            "Tỵ",
            "Thân",
            "Thìn",
            "Dần",
            "Mão",
            "Hợi",
            "Tân",
            "Giáp",
            "Ngọ",
            "Tuất",
            "Thân",
            "Mão",
            "Thân",
            "Tý",
            "Hợi",
            "Dần",
            "Tỵ",
            "Ngọ",
            "Dần",
            "Mùi",
            "-",
            "Thân",
            "Ngọ",
            "Mùi",
            "Hợi",
            "Tý",
            "Sửu",
            "Hợi",
            "Tỵ Dậu",
            "Tý",
            "Thân Dậu",
            "Hợi",
            "Thân Tuất",
            "Mão",
            "Mùi",
            "Tuất",
            "Hợi",
            "Mão",
            "Tỵ"
            )//12
        );

var SAO_TOT_TINHCHAT = new Array(
        "Tốt mọi việc",
        "Tốt mọi việc",
        "Tốt mọi việc",
        "Tốt mọi việc, kỵ tố tụng",
        "Tốt mọi việc, nhất là hôn thú",
        "Tốt mọi việc, nhất là xây dựng nhà cửa, khai trương và an táng",
        "Tốt mọi việc",
        "Tốt cho tế tự, giải oan, trừ được các sao xấu, chỉ kiêng kỵ động thổ. Nếu gặp trực khai thì rất tốt tức là ngày thiên xá gặp sinh khí",
        "Tốt mọi việc, nhất là làm nhà, sửa nhà, động thổ, trồng cây",
        "Tốt mọi việc",
        "Tốt mọi việc",
        "Tốt mọi việc",
        "Tốt cho việc xuất hành, giao dịch, cầu tài lộc",
        "Tốt cho việc cầu tài lộc, khai trương",
        "Tốt cho việc cầu tài lộc, khai trương",
        "Tốt cho việc cầu tài lộc, khai trương, xuất hành, di chuyển, giao dịch",
        "Tốt mọi việc",
        "Tốt cho việc làm nhà, làm gường",
        "Tốt mọi việc",
        "Tốt mọi việc, nhất là cầu phúc, tế tự",
        "Tốt mọi việc",
        "Tốt cho việc cầu tài, khai trương, giao dịch",
        "Tốt mọi việc",
            "Tốt mọi việc","Tốt mọi việc","Tốt mọi việc","Tốt mọi việc","Tốt đối với tang lễ",
        "Tốt mọi việc","Tốt mọi việc","Tốt mọi việc",
        "Tốt, nhưng gặp thụ tử thì xấu","Tốt cho việc tế tự,tố tụng, gải oan (trừ được các sao xấu)",
        "Tốt mọi việc, làm phúc, giá thú, xuất hành","Tốt mọi việc, nhất là giá thú","Tốt mọi việc, nhất là giá thú",
        "Tốt mọi việc, nhất là giá thú","Tốt mọi việc, nhất là xuất hành","Tốt mọi việc","Tốt mọi việc","Tốt về cầu tài lộc, khai trương",
        "Tốt về cầu tài lộc, khai trương","Tốt mọi việc","Tốt mọi việc","Hoàng Đạo - Tốt mọi việc","Hoàng Đạo - Tốt mọi việc",
        "Hoàng Đạo - Tốt mọi việc","Hoàng Đạo - Tốt mọi việc"
            );


var SAO_XAU_TEN = new Array(
        "Thiên Cương",
        "Thiên Lại",
        "Thiên Ngục Thiên Hoả",
        "Tiểu Hồng Sa",
        "Đại Hao",
        "Tiểu Hao",
        "Nguyệt phá",
        "Kiếp sát",
        "Địa phá",
        "Thổ phủ",
        "Thổ ôn",
        "Thiên ôn",
        "Thụ tử",
        "Hoang vu",
        "Thiên tặc",
        "Địa Tặc",
        "Hoả tai",
        "Nguyệt Hoả Độc Hoả",
        "Nguyệt Yếm",
        "Nguyệt Hư",
        "Hoàng Sa",
        "Lục Bất thành",
        "Nhân Cách",
        "Thần cách",
        "Phi Ma sát",
        "Ngũ Quỹ",
        "Băng tiêu ngoạ hãm",
        "Hà khôi Cẩu Giảo",
        "Vãng vong",
        "Cửu không",
        "Trùng Tang",
        "Trùng phục",
        "Chu tước hắc đạo",
        "Bạch hổ",
        "Huyền Vũ",
        "Câu Trận",
        "Lôi công",
        "Cô thần",
        "Quả tú",
        "Sát chủ",
        "Nguyệt Hình",
        "Tội chỉ",
        "Nguyệt Kiến",
        "Thiên địa chính chuyển",
        "Thiên địa chuyển sát",
        "Lỗ ban sát",
        "Phủ đầu dát",
        "Tam tang",
        "Ngũ hư",
        "Tứ thời đại mộ",
        "Thổ cẩm",
        "Ly sàng",
        "Tứ thời cô quả",
        "Không phòng",
        "Âm thác",
        "Dương thác",
        "Quỷ khốc"
        );

var SAO_XAU_MATRIX= new Array(
        new Array(
            "Tỵ",
            "Dậu",
            "Tý",
            "Tỵ",
            "Ngọ",
            "Tỵ",
            "Thân",
            "Hợi",
            "Hợi",
            "Dần",
            "Thìn",
            "Mùi",
            "Tuất",
            "Tỵ Dậu Sửu",
            "Thìn",
            "Sửu",
            "Sửu",
            "Tỵ",
            "Tuất",
            "Sửu",
            "Ngọ",
            "Dần",
            "Dậu",
            "Tỵ",
            "Tý",
            "Ngọ",
            "Tỵ",
            "Hợi",
            "Dần",
            "Thìn",
            "Giáp",
            "Canh",
            "Mão",
            "Ngọ",
            "Dậu",
            "Hợi",
            "Dần",
            "Tuất",
            "Thìn",
            "Tỵ",
            "Tỵ",
            "Ngọ",
            "Mão",
            "Quý Mão",
            "Ất Mão",
            "Tý",
            "Thìn",
            "Thìn",
            "Tỵ",
            "Ất Mùi",
            "Hợi",
            "Dậu",
            "Sửu",
            "Thìn",
            "Canh Tuất",
            "Giáp Dần",
            "Tuất"
            ),//1
                new Array(
            "Tý",
            "Ngọ",
            "Mão",
            "Dậu",
            "Mùi",
            "Ngọ",
            "Dậu Tuất",
            "Thân",
            "Tý",
            "Mão",
            "Tỵ",
            "Tuất",
            "Thìn",
            "Tỵ Dậu Sửu",
            "Dậu",
            "Tý",
            "Mùi",
            "Thìn",
            "Dậu",
            "Tuất",
            "Dần",
            "Ngọ",
            "Mùi",
            "Mão",
            "Dậu",
            "Dần",
            "Tý",
            "Ngọ",
            "Tỵ",
            "Sửu",
            "Ất",
            "Tân",
            "Tỵ",
            "Thân",
            "Hợi",
            "Tỵ",
            "Hợi",
            "Hợi",
            "Tỵ",
            "Tý",
            "Tý",
            "Tý",
            "-",
            "-",
            "-",
            "-",
            "-",
            "-",
            "Dậu",
            "-",
            "-",
            "-",
            "-",
            "Tỵ",
            "Tân Dậu",
            "Ất Mão",
            "Tuất"
            ),//2
                new Array(
            "Mùi",
            "Mão",
            "Ngọ",
            "Sửu",
            "Thân",
            "Mùi",
            "Tuất",
            "Tỵ",
            "Sửu",
            "Thìn",
            "Ngọ",
            "Thìn",
            "Hợi",
            "Tỵ Dậu Sửu",
            "Dần",
            "Hợi",
            "Dần",
            "Mão",
            "Thân",
            "Mùi",
            "Tý",
            "Tuất",
            "Tỵ",
            "Sửu",
            "Ngọ",
            "Thìn",
            "Sửu",
            "Sửu",
            "Thân",
            "Tuất",
            "Kỷ",
            "Kỷ",
            "Mùi",
            "Tuất",
            "Tỵ",
            "Mão",
            "Tỵ",
            "Tý",
            "Ngọ",
            "Mùi",
            "Thìn",
            "Mùi",
            "-",
            "-",
            "-",
            "-",
            "-",
            "-",
            "Sửu",
            "-",
            "-",
            "-",
            "-",
            "Tý",
            "Canh Thân",
            "Giáp Thìn",
            "Tuất"
            ),//3
                new Array(
            "Dần",
            "Tý",
            "Dậu",
            "Tỵ",
            "Dậu",
            "Thân",
            "Hợi",
            "Dần",
            "Dần",
            "Tỵ",
            "Mùi",
            "Dần",
            "Tỵ",
            "Thân Tý Thìn",
            "Mùi",
            "Tuất",
            "Thân",
            "Dần",
            "Mùi",
            "Thìn",
            "Ngọ",
            "Tỵ",
            "Mão",
            "Hợi",
            "Mão",
            "Dậu",
            "Dần",
            "Thân",
            "Hợi",
            "Mùi",
            "Bính",
            "Nhâm",
            "Dậu",
            "Tý",
            "Mão",
            "Sửu",
            "Thân",
            "Sửu",
            "Mùi",
            "Mão",
            "Thân",
            "Sửu",
            "Ngọ",
            "Bính Ngọ",
            "Bính Ngọ",
            "Mão",
            "Mùi",
            "Mùi",
            "Thân",
            "Bính Tuất",
            "Dần",
            "Dần,Ngọ",
            "Thìn",
            "Tuất",
            "Đinh Mùi",
            "Đinh Tỵ",
            "Tuất"
            ),//4
                new Array(
            "Dậu",
            "Dậu",
            "Tý",
            "Dậu",
            "Tuất",
            "Dậu",
            "Tý Sửu",
            "Hợi",
            "Mão",
            "Ngọ",
            "Thân",
            "Ngọ",
            "Tý",
            "Thân Tý Thìn",
            "Tý",
            "Dậu",
            "Mão",
            "Sửu",
            "Ngọ",
            "Sửu",
            "Dần",
            "Dậu",
            "Sửu",
            "Dậu",
            "Tý",
            "Mão",
            "Mão",
            "Mão",
            "Mão",
            "Mão",
            "Đinh",
            "Quý",
            "Hợi",
            "Dần",
            "Sửu",
            "Mùi",
            "Dần",
            "Dần",
            "Thân",
            "Thân",
            "Ngọ",
            "Thân",
            "-",
            "-",
            "-",
            "-",
            "-",
            "-",
            "Tý",
            "-",
            "-",
            "-",
            "-",
            "Hợi",
            "Bính Ngọ",
            "Bính Ngọ",
            "Tuất"
            ),//5
                new Array(
            "Thìn",
            "Ngọ",
            "Mão",
            "Sửu",
            "Hợi",
            "Tuất",
            "Sửu",
            "Thân",
            "Thìn",
            "Mùi",
            "Dậu",
            "Tý",
            "Ngọ",
            "Thân Tý Thìn",
            "Tỵ",
            "Thân",
            "Dậu",
            "Tý",
            "Tỵ",
            "Tuất",
            "Tý",
            "Sửu",
            "Hợi",
            "Mùi",
            "Dậu",
            "Thân",
            "Tuất",
            "Tuất",
            "Ngọ",
            "Tý",
            "Kỷ",
            "Mậu",
            "Sửu",
            "Thìn",
            "Mùi",
            "Dậu",
            "Hợi",
            "Mão",
            "Dậu",
            "Tuất",
            "Sửu",
            "Dần",
            "-",
            "-",
            "-",
            "-",
            "-",
            "-",
            "Thìn",
            "-",
            "-",
            "-",
            "-",
            "Mùi",
            "Đinh Tỵ",
            "Đinh Mùi",
            "Tuất"
            ),//6
                new Array(
            "Hợi",
            "Mão",
            "Ngọ",
            "Tỵ",
            "Tý",
            "Hợi",
            "Dần",
            "Tỵ",
            "Tỵ",
            "Thân",
            "Tuất",
            "Dậu",
            "Sửu",
            "Hợi Mão Mùi",
            "Tuất",
            "Mùi",
            "Thìn",
            "Hợi",
            "Thìn",
            "Mùi",
            "Ngọ",
            "Thân",
            "Dậu",
            "Tỵ",
            "Ngọ",
            "Sửu",
            "Hợi",
            "Tỵ",
            "Dậu",
            "Dậu",
            "Canh",
            "Giáp",
            "Mão",
            "Ngọ",
            "Dậu",
            "Hợi",
            "Tỵ",
            "Thìn",
            "Tuất",
            "Sửu",
            "Dần",
            "Dậu",
            "Dậu",
            "Đinh Dậu",
            "Tân Dậu",
            "Ngọ",
            "Dậu",
            "Tuất",
            "Hợi",
            "Tân Sửu",
            "Tỵ",
            "Tuất",
            "Mùi",
            "Dần",
            "Giáp Thìn",
            "Canh Thân",
            "Tuất"
            ),//7
                new Array(
            "Ngọ",
            "Tý",
            "Dậu",
            "Dậu",
            "Sửu",
            "Tý",
            "Mão Thìn",
            "Dần",
            "Ngọ",
            "Dậu",
            "Hợi",
            "Thân",
            "Mùi",
            "Hợi Mão Mùi",
            "Mão",
            "Ngọ",
            "Tuất",
            "Tuất",
            "Mão",
            "Thìn",
            "Dần",
            "Tý",
            "Mùi",
            "Mão",
            "Mão",
            "Tỵ",
            "Ngọ",
            "Tý",
            "Tý",
            "Ngọ",
            "Tân",
            "Ất",
            "Tỵ",
            "Thân",
            "Hợi",
            "Tỵ",
            "Thân",
            "Tỵ",
            "Hợi",
            "Hợi",
            "Dậu",
            "Mão",
            "-",
            "-",
            "-",
            "-",
            "-",
            "-",
            "Mão",
            "-",
            "-",
            "-",
            "-",
            "Mão",
            "Ất Mão",
            "Tân Dậu",
            "Tuất"
            ),//8
                new Array(
            "Sửu",
            "Dậu",
            "Tý",
            "Sửu",
            "Dần",
            "Sửu",
            "Thìn",
            "Hợi",
            "Mùi",
            "Tuất",
            "Tý",
            "Tỵ",
            "Dần",
            "Hợi Mão Mùi",
            "Thân",
            "Tỵ",
            "Tỵ",
            "Dậu",
            "Dần",
            "Sửu",
            "Tý",
            "Thìn",
            "Tỵ",
            "Sửu",
            "Tý",
            "Tý",
            "Mùi",
            "Mùi",
            "Thìn",
            "Dần",
            "Kỷ",
            "Kỷ",
            "Mùi",
            "Tuất",
            "Tỵ",
            "Mão",
            "Dần",
            "Ngọ",
            "Tý",
            "Ngọ",
            "Mùi",
            "Tuất",
            "-",
            "-",
            "-",
            "-",
            "-",
            "-",
            "Mùi",
            "-",
            "-",
            "-",
            "-",
            "Ngọ",
            "Giáp Dần",
            "Canh Tuất",
            "Tuất"
            ),//9
                new Array(
            "Thân",
            "Ngọ",
            "Mão",
            "Tỵ",
            "Mão",
            "Dần",
            "Tỵ",
            "Thân",
            "Thân",
            "Hợi",
            "Sửu",
            "Hợi",
            "Thân",
            "Dần Ngọ Tuất",
            "Sửu",
            "Thìn",
            "Hợi",
            "Thân",
            "Sửu",
            "Tuất",
            "Ngọ",
            "Hợi",
            "Mão",
            "Hợi",
            "Dậu",
            "Hợi",
            "Thân",
            "Dần",
            "Mùi",
            "Hợi",
            "Nhâm",
            "Nhâm",
            "Dậu",
            "Tý",
            "Mão",
            "Sửu",
            "Hợi",
            "Mùi",
            "Sửu",
            "Dậu",
            "Hợi",
            "Thìn",
            "Tý",
            "Canh Tý",
            "Nhâm Tý",
            "Dậu",
            "Tý",
            "Sửu",
            "Dần",
            "Nhâm Thìn",
            "Thân",
            "Tỵ",
            "Tuất",
            "Thân",
            "Quý Sửu",
            "Quý Hợi",
            "Tuất"
            ),//10
                new Array(
            "Mão",
            "Mão",
            "Ngọ",
            "Dậu",
            "Thìn",
            "Mão",
            "Ngọ Mùi",
            "Tỵ",
            "Dậu",
            "Tý",
            "Dần",
            "Tý",
            "Mão",
            "Dần Ngọ Tuất",
            "Ngọ",
            "Mão",
            "Ngọ",
            "Mùi",
            "Tý",
            "Mùi",
            "Dần",
            "Mão",
            "Sửu",
            "Dậu",
            "Ngọ",
            "Mùi",
            "Dậu",
            "Dậu",
            "Tuất",
            "Thân",
            "Quý",
            "Quý",
            "Hợi",
            "Dần",
            "Sửu",
            "Mùi",
            "Tỵ",
            "Thân",
            "Dần",
            "Dần",
            "Mão",
            "Hợi",
            "-",
            "-",
            "-",
            "-",
            "-",
            "-",
            "Ngọ",
            "-",
            "-",
            "-",
            "-",
            "Dậu",
            "Nhâm Tý",
            "Nhâm Tý",
            "Tuất"
            ),//11
                new Array(
            "Tuất",
            "Tý",
            "Dậu",
            "Sửu",
            "Tỵ",
            "Thìn",
            "Mùi",
            "Dần",
            "Tuất",
            "Sửu",
            "Mão",
            "Mão",
            "Dậu",
            "Dần Ngọ Tuất",
            "Hợi",
            "Dần",
            "Tý",
            "Ngọ",
            "Hợi",
            "Thìn",
            "Tý",
            "Mùi",
            "Hợi",
            "Mùi",
            "Mão",
            "Tuất",
            "Thìn",
            "Thìn",
            "Sửu",
            "Tỵ",
            "Kỷ",
            "Kỷ",
            "Sửu",
            "Thìn",
            "Mùi",
            "Dậu",
            "Thân",
            "Dậu",
            "Mão",
            "Thìn",
            "Tuất",
            "Tỵ",
            "-",
            "-",
            "-",
            "-",
            "-",
            "-",
            "Tuất",
            "-",
            "-",
            "-",
            "-",
            "Sửu",
            "Quý Hợi",
            "Quý Sửu",
            "Tuất"
            )//12
        );

function cacsaotot(lunarMonth, lunarDayCanChi){
    var CHI = lunarDayCanChi.split(" ")[1];
        var CAN = lunarDayCanChi.split(" ")[0];
    var chi_so_gia;

    switch(CHI){
    case "Tý": chi_so_gia=1; break;
    case "Sửu":  chi_so_gia=2; break;
    case "Dần": chi_so_gia=3; break;
    case "Mão":  chi_so_gia=4; break;
    case "Thìn": chi_so_gia=5; break;
    case "Tỵ": chi_so_gia=6; break;
    case "Ngọ":  chi_so_gia=7; break;
    case "Mùi":  chi_so_gia=8; break;
    case "Thân":  chi_so_gia=9; break;
    case "Dậu":  chi_so_gia=10; break;
    case "Tuất":  chi_so_gia=11; break;
    case "Hợi":  chi_so_gia=12; break;
    }

    var can_so_gia;

    switch(CAN){
    case "Giáp": can_so_gia=1; break;
    case "Ất":  can_so_gia=2; break;
    case "Bính": can_so_gia=3; break;
    case "Đinh":  can_so_gia=4; break;
    case "Mậu": can_so_gia=5; break;
    case "Kỷ": can_so_gia=6; break;
    case "Canh":  can_so_gia=7; break;
    case "Tân":  can_so_gia=8; break;
    case "Nhâm":  can_so_gia=9; break;
    case "Quý":  can_so_gia=10; break;
    }

    var final_can_so_gia = can_so_gia + 12;


    var SAOTOT="";
    var js=1;

    for (var j=0;j<=48;j++){

        if (lunarDayCanChi == SAO_TOT_MATRIX[lunarMonth-1][j] || SAO_TOT_MATRIX[lunarMonth-1][j].indexOf(CAN) != -1 || SAO_TOT_MATRIX[lunarMonth-1][j].indexOf(CHI) != -1)
            if (js==1){
              SAOTOT = SAO_TOT_TEN[j];
              js++;
            }else
                SAOTOT += ", "+SAO_TOT_TEN[j];
    }

    return SAOTOT;
}

function cacsaoxau(lunarMonth, lunarDayCanChi){
    var CHI = lunarDayCanChi.split(" ")[1];
        var CAN = lunarDayCanChi.split(" ")[0];
    var chi_so_gia;

    switch(CHI){
    case "Tý": chi_so_gia=1; break;
    case "Sửu":  chi_so_gia=2; break;
    case "Dần": chi_so_gia=3; break;
    case "Mão":  chi_so_gia=4; break;
    case "Thìn": chi_so_gia=5; break;
    case "Tỵ": chi_so_gia=6; break;
    case "Ngọ":  chi_so_gia=7; break;
    case "Mùi":  chi_so_gia=8; break;
    case "Thân":  chi_so_gia=9; break;
    case "Dậu":  chi_so_gia=10; break;
    case "Tuất":  chi_so_gia=11; break;
    case "Hợi":  chi_so_gia=12; break;
    }

    var can_so_gia;

    switch(CAN){
    case "Giáp": can_so_gia=1; break;
    case "Ất":  can_so_gia=2; break;
    case "Bính": can_so_gia=3; break;
    case "Đinh":  can_so_gia=4; break;
    case "Mậu": can_so_gia=5; break;
    case "Kỷ": can_so_gia=6; break;
    case "Canh":  can_so_gia=7; break;
    case "Tân":  can_so_gia=8; break;
    case "Nhâm":  can_so_gia=9; break;
    case "Quý":  can_so_gia=10; break;
    }

    var final_can_so_gia = can_so_gia + 12;


    var SAOXAU="";
    var js=1;

    for (var j=0;j<=48;j++){

        if (lunarDayCanChi == SAO_XAU_MATRIX[lunarMonth-1][j] || SAO_XAU_MATRIX[lunarMonth-1][j].indexOf(CAN) != -1 || SAO_XAU_MATRIX[lunarMonth-1][j].indexOf(CHI) != -1)
            if (js==1){
              SAOXAU = SAO_XAU_TEN[j];
              js++;
            }else
                SAOXAU += ", "+SAO_XAU_TEN[j];
    }

    return SAOXAU;
}

function huong_xuat_hanh(lunarDayCanChi){
    var CAN = lunarDayCanChi.split(" ")[0];
    var hythan_huong="";
    var taithan_huong="";
    var hacthan_huong="";

    if (CAN == "Giáp" || CAN == "Kỷ") hythan_huong = "Đông Bắc";else
        if (CAN == "Ất" || CAN == "Canh") hythan_huong = "Tây Bắc";else
            if (CAN == "Bính" || CAN == "Tân") hythan_huong = "Tây Nam";else
                if (CAN == "Đinh" || CAN == "Nhâm") hythan_huong = "Nam";else
                     hythan_huong = "Đông Nam";

    if (CAN == "Giáp" || CAN == "Ất") taithan_huong = "Đông Nam";else
        if (CAN == "Bính" || CAN == "Đinh") taithan_huong = "Đông";else
            if (CAN == "Mậu") taithan_huong = "Bắc";else
                if (CAN == "Kỷ") taithan_huong = "Nam";else
                if (CAN == "Canh" || CAN == "Tân") taithan_huong = "Tây Nam";else
                    if (CAN == "Nhâm") taithan_huong = "Tây";else
                     taithan_huong = "Tây Bắc";

    if (lunarDayCanChi == "Kỷ Dậu" || lunarDayCanChi == "Canh Tuất" || lunarDayCanChi == "Tân Hợi" || lunarDayCanChi == "Nhâm Tý"
            || lunarDayCanChi == "Quý Sửu" || lunarDayCanChi == "Giáp Dần")
        hacthan_huong = "Đông Bắc";
    else
        if (lunarDayCanChi == "Ất Mão" || lunarDayCanChi == "Bính Thìn" || lunarDayCanChi == "Đinh Tỵ" || lunarDayCanChi == "Mậu Ngọ"
                || lunarDayCanChi == " Kỷ Mùi" )
                    hacthan_huong = "Đông";
    else
            if (lunarDayCanChi == "Canh Thân" || lunarDayCanChi == "Tân Dậu" || lunarDayCanChi == "Nhâm Tuất" || lunarDayCanChi == "Quý Hợi"
                    || lunarDayCanChi == "Giáp Tý" || lunarDayCanChi == "Ất Sửu" )
                        hacthan_huong = "Đông Nam";
            else
                    if (lunarDayCanChi == "Bính Dần" || lunarDayCanChi == "Đinh Mão" || lunarDayCanChi == "Mậu Thìn" || lunarDayCanChi == "Kỷ Tỵ"
                            || lunarDayCanChi == "Canh Ngọ" )
                                hacthan_huong = "Nam";
                    else
                            if (lunarDayCanChi == "Tân Mùi" || lunarDayCanChi == "Nhâm Thân" || lunarDayCanChi == "Quý Dậu" || lunarDayCanChi == "Giáp Tuất"
                                    || lunarDayCanChi == "Ất Hợi" || lunarDayCanChi == "Bính Tý" )
                                        hacthan_huong = "Tây Nam";
                            else
                                    if (lunarDayCanChi == "Đinh Sửu" || lunarDayCanChi == "Mậu Dần" || lunarDayCanChi == "Kỷ Mão" || lunarDayCanChi == "Canh Thìn"
                                            || lunarDayCanChi == "Tân Tỵ" )
                                                hacthan_huong = "Tây";
                                    else
                                            if (lunarDayCanChi == "Nhâm Ngọ" || lunarDayCanChi == "Quý Mùi" || lunarDayCanChi == "Giáp Thân" || lunarDayCanChi == "Ất Dậu"
                                                    || lunarDayCanChi == "Bính Tuất" || lunarDayCanChi == "Đinh Hợi")
                                                        hacthan_huong = "Tây Bắc";
                                            else
                                                    if (lunarDayCanChi == "Mậu Tý" || lunarDayCanChi == "Kỷ Sửu" || lunarDayCanChi == "Canh Dần" || lunarDayCanChi == "Tân Mão"
                                                            || lunarDayCanChi == "Nhâm Thìn")
                                                                hacthan_huong = "Bắc";

    var rfinal="&bull; Tài Thần: <b>"+taithan_huong+"</b><br>&bull; Hỷ Thần: <b>"+hythan_huong+"</b>";
    if (hacthan_huong)
        rfinal+="<br>&bull; Hạc Thần:<b>"+hacthan_huong+"</b>";

    return rfinal;
}
