/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

Item{
    Rectangle {
        id: rectangle1
        anchors.fill: parent; anchors.bottomMargin: 0
        visible: true
        opacity:0.9

        Component {
                id: listDelegate
                Rectangle {
                    height:65
                Button {
                    id: button1
                     y: 3; width: parent.parent.width; height: 60
                    onClicked: {
                        getText(idm)
                    }

                    focus:true
                    text: name
                }
                }
            }

        ListModel {
                 id: listModel

                 ListElement {
                     idm:1;name: "Hôm Nay";
                 }
                 ListElement {
                    idm:2; name: "Tới Ngày Âm";
                 }
                 ListElement {
                     idm:3;name: "Tới Ngày Dương";
                 }
                 ListElement {
                    idm:4; name: "Xem Ngày Tốt/Xấu, Hoàng Đạo ...";
                 }
                 ListElement {
                    idm:5; name: "Xem Theo Tháng";
                 }
                 /*ListElement {
                    idm:7; name: "Đổi Theme";
                 }*/
                 ListElement {
                    idm:6; name: "Giới Thiệu";
                 }
         }

        ListView {
              id: listView
              anchors.fill: parent;anchors.topMargin: 35;anchors.leftMargin: 5;anchors.rightMargin: 5;
              model: listModel
              delegate: listDelegate
              focus: true
        }

    }

    ToolBarSingle { id: toolBar; height: 50;
        y: screen.height-78
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:
        {
            screen.state="mainscreen"
        }
    }

    function getText(id) {
        switch(id){
        case 1:screen.reset();break;
        case 2: screen.state="amdatetimedialog";break;
        case 3: screen.state="datetimedialog";break;
        case 4: screen.state="xemngaytotxauhoangdao";break;
        case 5: screen.state="xemtheothang";break;
        case 6: screen.state="aboutdialog";break;
        case 7: screen.state="changetheme";break;
        default:
            screen.state="nofeaturedialog";break;
        }

    }

    transitions: [
        Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutBack } }
    ]
}
