/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/


#include <QtGui/QApplication>
#include <QtGui/QDesktopWidget>
#include <QtDeclarative/QDeclarativeContext>

#include "qmlapplicationviewer.h"
#include "lunarcalendar.h"

#ifdef Q_WS_MAEMO_5
#include <QtOpenGL/QGLWidget>
#endif

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QmlApplicationViewer viewer;

     app.setApplicationVersion(APP_VERSION);

    LunarCalendar lc;

    viewer.rootContext()->setContextProperty("ROOT", &viewer);
    viewer.rootContext()->setContextProperty("LC", &lc);

    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    viewer.setSource(QUrl("qrc:/qml/LichViet/main.qml"));

    viewer.setWindowTitle(QString::fromUtf8("Lịch Việt"));

#ifdef Q_WS_MAEMO_5
    QGLFormat fmt = QGLFormat::defaultFormat();
    fmt.setDoubleBuffer(true);

    QGLWidget *glWidget = new QGLWidget(fmt);
    viewer.setViewport(glWidget);
#endif

#if defined(Q_WS_MAEMO_5) || defined(Q_OS_SYMBIAN)
            viewer.showFullScreen();
#else
            viewer.show();
 #endif

    return app.exec();
}
