/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

import "amlich-hnd.js" as AmLich
import "xemngaytotxau.js" as NTX

Item{
    id:main_item

    property string day_month_year_LN_CN:  ""
    property string nhi_thap_bat_tu:  ""
    property string truc:  ""
    property string luan_giai:  ""
    property string cac_sao_xau:  ""
    property string cac_sao_tot:  ""
    property string huong_xuat_hanh:  ""

    property string warnning:  "<span style='color:red;'>Thông tin trên đây được lấy nguồn từ <a href='http://www.xemngay.com'>www.xemngay.com</a> và chỉ mang tính chất <b>tham khảo</b></span>."

    Rectangle {
        id: rectangle1
        x: 0
        y: -5
        anchors.rightMargin: 0
        anchors.leftMargin: 0
        anchors.topMargin:30
        anchors.fill: parent; anchors.bottomMargin: 16
        visible: true
        opacity:0.9

        Component {
            id: listDelegate

                Column {

                    Rectangle {
                                        width:rectangle1.width;
                                        y:30;
                                        x:0
                                        height:1
                                        border.color: "#b57e8f"
                    }

                    width:rectangle1.width

                    Rectangle{
                        width:rectangle1.width;
                        height:10;color:"transparent"
                    }

                    Text { x:5;y:50;text:getHD(name,idm) ;textFormat: Text.RichText;wrapMode: Text.WordWrap; font.pixelSize: 20
                        font.family: "Tahoma";width:parent.width;}

                    Rectangle{
                        width:rectangle1.width;
                        height:10;color:"transparent"
                    }
                }


        }

        ListModel {
                 id: listModel

                 ListElement {
                     idm:0;name: "";
                 }
                 ListElement {
                     idm:-1;name: "";
                 }
                 ListElement {
                     idm:1;name: "<b>Giờ Hoàng Đạo</b>";
                 }
                 ListElement {
                     idm:2;name: "<b>Tiết Khí</b>";
                 }
                ListElement {
                     idm:3;name: "<b>Nhị Thập Bát Tú</b>";
                 }
                ListElement {
                     idm:-2;name: "<b>Hướng Xuất Hành</b>";
                 }
                ListElement {
                     idm:6;name: "<b>Các Sao Tốt</b>";
                 }
               ListElement {
                     idm:7;name: "<b>Các Sao Xấu</b>";
                 }
               ListElement {
                   idm:8;name: "";
               }

               /* ListElement {
                     idm:5;name: "<b>Đánh Giá</b>";
                 }*/
         }



        ListView {
              id: listView
              anchors.fill: parent;anchors.topMargin: 0;anchors.leftMargin: 0; anchors.bottomMargin: 16
              model: listModel
              delegate: listDelegate
              focus: true
        }

    }

    ToolBarSingle { id: toolBar; height: 50;
        y: screen.height-78
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:
        {
            screen.state="mainscreen"
        }
    }

    function getHD(name,idm){
        if (name.length){
            name="<span style='color:blue;'>"+name+"</span><br>";
        }

        switch(idm){
        case 0 : return name+ main_item.day_month_year_LN_CN;break;
        case 1 : return name+screen.lunarGioHoangDao;break;
        case 2 : return name+screen.lunarTietKhi();break;
        case 3 : return name+main_item.nhi_thap_bat_tu; break;
        case 5 :  return name+main_item.luan_giai;break;
        case -1: return name+main_item.truc;break;
        case 6: return name+main_item.cac_sao_tot;break;
        case 7: return name+main_item.cac_sao_xau;break;
        case -2: return name+main_item.huong_xuat_hanh;break;
        case 8: return main_item.warnning;break;
        }
    }

    function reset(){
        main_item.day_month_year_LN_CN = AmLich.getTHU(screen.jd)+",ngày <b>"+screen.curDay+"</b> tháng <b>"+screen.curMonth+"</b> năm <b>"+screen.curYear+"</b><br>Ngày <b>"+screen.lunarDay+"</b> tháng <b>"+screen.lunarMonth+"</b> năm <b>"+screen.lunarYear+"</b> (<b>"+screen.lunarYearInt+"</b>)";
        main_item.nhi_thap_bat_tu = NTX.sao(screen.curYear,AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear).jd - AmLich.getLunarDate(1,1,screen.curYear).jd);
        main_item.truc = NTX.truc(screen.lunarMonth, screen.lunarDayCanChi, screen.lunarMonthCanChi);
        main_item.cac_sao_tot = NTX.cacsaotot(screen.lunarMonth, screen.lunarDayCanChi);
        main_item.cac_sao_xau = NTX.cacsaoxau(screen.lunarMonth, screen.lunarDayCanChi);
        main_item.luan_giai = NTX.luangiai(screen.curDay);
        main_item.huong_xuat_hanh = NTX.huong_xuat_hanh(screen.lunarDayCanChi);
    }

    transitions: [
        Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutBack } }
    ]
}
