/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtDeclarative module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 1.0

Item {
    id: titleBar
    property string untaggedString: " "
    property string taggedString: " "

    BorderImage { source: theme_manager.theme.titlebar.sci; width: parent.width; height: parent.height + 14; y: -7 }

    Item {
        id: container
        width: (parent.width * 2) - 55 ; height: parent.height

        function accept() {
            titleBar.state = ""
            background.state = ""
            rssModel.tags = editor.text
        }


        Image {
            id: quitButton
            x: screen.width - 50
            anchors.verticalCenter: parent.verticalCenter
            source:  theme_manager.theme.titlebar.button
            MouseArea {
                anchors.fill: parent
                onPressed:{
                    parent.source= theme_manager.theme.titlebar.button_pressed
                }
                onReleased:{
                     parent.source=theme_manager.theme.titlebar.button
                }

                onClicked: Qt.quit()
            }
        }

        Image {
            id: minimizeButton
            x:4
            anchors.verticalCenter: parent.verticalCenter
            source:  theme_manager.theme.titlebar.minimize_button

            MouseArea {
                anchors.fill: parent
                onPressed:{
                    parent.source= theme_manager.theme.titlebar.minimize_button_pressed
                }
                onReleased:{
                     parent.source=theme_manager.theme.titlebar.minimize_button
                }

                onClicked: ROOT.minimize();
            }
        }

        Text {
            id: categoryText
            x:60
            anchors {
                verticalCenter: parent.verticalCenter
            }
            elide: Text.ElideLeft
            text: "Lịch Việt"
            font.bold: true; color: "White"; style: Text.Raised; styleColor: "Black"
            font.pixelSize: 24
            font.family: "Tahoma"
        }
    }

    states: State {
        name: "Tags"
        PropertyChanges { target: container; x: -tagButton.x + 5 }
        PropertyChanges { target: editor; focus: true }
    }

    /*transitions: Transition {
        NumberAnimation { properties: "x"; easing.type: Easing.InOutQuad }
    }*/
}
