/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0
import "../DatePicker/component" as Comp

import "amlich-hnd.js" as AmLich
import "amlich-aa98.js" as AmLich98

import "CacNgayLeTrongNam.js" as CNLTN

Item{
    id: item1

    Rectangle{
        id: fullmonthREC
        anchors.fill: parent; anchors.bottomMargin: 0
        visible: true
        opacity:0.9

            Component {
                id: contactDelegate
                Item {
                    width: grid.cellWidth; height: {
                        if (header)
                            return grid.cellHeight - 15;
                        else return grid.cellHeight;
                    }
                    Rectangle {
                        anchors.fill: parent;anchors.rightMargin: 2;anchors.topMargin: 2;
                        Text { color: {
                                if (header)
                                  return  "#000000";
                                else{
                                    var stemp = AmLich98.convertSolar2Lunar(txtDATEpv.currentIndex+1,curMonth,curYear,7);
                                    if (CNLTN.is_holiday(day, month, stemp[0], stemp[1]))
                                        return theme_manager.theme.markdate.holidays;
                                    else
                                        return "#007070"
                                }
                            }

                            text: name; anchors.horizontalCenter: parent.horizontalCenter
                            font.pixelSize: 21;font.bold: true;font.family: "Tahoma"
                            anchors.topMargin: 0;
                        }

                        color: {
                            if (header)
                                return "#FAFAFF";
                            else{
                                if (inmonth){
                                    if (day==initcurDay && month==initcurMonth && year==initcurYear)
                                        return "#00EBEB";
                                    else
                                      return "lightsteelblue";
                                }
                                else
                                    return "#AAAAAA";
                            }
                        }
                         radius: 4
                         MouseArea{
                             id:fullmonthMouse
                             anchors.fill: parent

                             onClicked: {
                               if (index >= 7){
                                   LC.reset(day,month,year)
                                   screen.calculateLunar(day,month,year)
                                   screen.state="mainscreen"
                                   screen.refresh()
                                   maindatemodel.reset()
                                   txtDATEpv.currentIndex = day-1;
                               }
                             }

onPressed:{
    if (index >= 7)
        parent.color="#F0F0F0"
}

onReleased:{
      if (index >= 7){
          if (inmonth){
              if (day==initcurDay && month==initcurMonth && year==initcurYear)
                  parent.color="#00EBEB";
              else
                  parent.color="lightsteelblue";
          }else
              parent.color="#AAAAAA";
      }
}

onCanceled:{
    if (index >= 7){
        if (inmonth)
        {if (day==initcurDay && month==initcurMonth && year==initcurYear) parent.color="#00EBEB"; else parent.color="lightsteelblue";}
        else
         parent.color="#AAAAAA";
    }

}

                         }
                    }
                }
            }

            GridView {
                id: grid
                x: -335
                y: 41
                width:800
                height: 480
                anchors.horizontalCenterOffset: 15
                anchors.bottomMargin: -52
                anchors.topMargin: 42
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.bottom: parent.bottom
                anchors.top: parent.top
                cellWidth: 110; cellHeight: 50
                //Dung : 64 | Nam :110
                model:lmodel
                delegate: contactDelegate
                focus: false
            }

            ListModel {
                id:lmodel

                Component.onCompleted: {
                    reset()
                }

                function reset(){
                    for(var i=0;i<42;i++){
                        append({header:false,name:"",inmonths:false,day:0,month:0,year:0})
                    }
                }

                ListElement {
                                        header:true;inmonth:false;day:0;month:0;year:0
                    name: "CN"
                }

                ListElement {
                    header:true;inmonth:false;day:0;month:0;year:0
                    name: "Hai"
                }

                ListElement {
                    header:true;inmonth:false;day:0;month:0;year:0
                    name: "Ba"
                }
                ListElement {
                                        header:true;inmonth:false;day:0;month:0;year:0
                    name: "Tư"
                }
                ListElement {
                                        header:true;inmonth:false;day:0;month:0;year:0
                    name: "Năm"
                }
                ListElement {
                                        header:true;inmonth:false;day:0;month:0;year:0
                    name: "Sáu"
                }
                ListElement {
                                        header:true;inmonth:false;day:0;month:0;year:0
                    name: "Bảy"
                }
            }

            Component.onCompleted: {
            }

    }

    ToolBarSingle { id: toolBar; height: 50;
        y: screen.height-78
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:
        {
            screen.state="mainscreen"
        }
    }

    transitions: [
        Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutBack } }
    ]

    states: [
        State {
            name: "xemtheothang"
            PropertyChanges {
                target: grid
                width : screen.width
                height: screen.height
                cellWidth: {
                    if (screen.width>=800)
                         return 110;
                    else
                        return 64;
                }
            }
        }
    ]

    function get_prevmonth(startfrom){
        var cMonth=screen.curMonth;
        var cYear=screen.curYear;
        var pmonth = [];
        if (cMonth == 1){
            cMonth = 12
            cYear--;
        }else
            cMonth--;
         var daysofthemonthyear = LC.calDays(cMonth,cYear);
        for (var i=daysofthemonthyear;i>daysofthemonthyear-startfrom;i--){
            var lunarcl = AmLich.getLunarDate(i,cMonth,cYear)
            pmonth.push({duong:i, am:lunarcl.day, month:cMonth, year:cYear})
        }
        return pmonth.reverse()
    }

    function get_nextmonth(startfrom){
        var cMonth=screen.curMonth;
        var cYear=screen.curYear;
         var pmonth = [];
        if (cMonth==12){
            cMonth = 1;
            cYear++;
        }else
            cMonth++;

        for (var i=1;i<=startfrom;i++){
          var lunarcl = AmLich.getLunarDate(i,cMonth,cYear)
            pmonth.push({duong:i, am:lunarcl.day, month:cMonth, year:cYear});
        }
           return pmonth.reverse();
    }

    function reset(){
        var firstdayofthemonthyear = AmLich.getLunarDate(1,screen.curMonth,screen.curYear).jd;
        var startfrom = (firstdayofthemonthyear+1)%7;
        var daysofthemonthyear = LC.calDays(screen.curMonth,screen.curYear);
        var j=1;

        var totalslot = 42;

        var nextmonth = get_nextmonth(totalslot - (startfrom+daysofthemonthyear))
        var prevmonth = get_prevmonth(startfrom)

        var dayclick, monthclick, yearclick;

        while(lmodel.count>7){
            lmodel.remove(lmodel.count-1);
        }

        var datas1,datas,lunarclmonth,inmonths;

        for (var i=7;i<49;i++){
            var realnumber = i - 7;
            if (realnumber >= startfrom && j<= daysofthemonthyear){
            var lunarcl = AmLich.getLunarDate(j,screen.curMonth,screen.curYear)
            if (lunarcl.day==1){
                lunarclmonth = "/"+lunarcl.month
            }else{
                lunarclmonth = ""
            }

            datas = j+"<br><span style='font-size:18px;float:right;color:#700070;'>&nbsp;&nbsp;"+lunarcl.day+lunarclmonth+"</span>";
            dayclick = j;
            monthclick = screen.curMonth;
            yearclick = screen.curYear;
            inmonths = true;
                j++;
            }else{
                if (realnumber<startfrom){
                    datas1= prevmonth[realnumber];
                }else
                {
                    datas1=nextmonth[(totalslot-realnumber)-1];
                }
                dayclick = datas1.duong;
                monthclick = datas1.month;
                yearclick = datas1.year;
                datas = "<span style='color:grey;font-weight:normal;'>"+datas1.duong+"</span><br><span style='font-size:18px;float:right;color:#CCFFFF;'>&nbsp;&nbsp;"+datas1.am+"</span>";
                inmonths=false;
            }

            lmodel.append({header:false,name:datas,inmonth:inmonths,day:dayclick,month:monthclick,year:yearclick})
        }
    }
}
