/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

Item{
    id: item1
    Rectangle {
        id: rectangle1
        anchors.fill: parent; anchors.bottomMargin: 0
        visible: true
        opacity:0.8

    Image {
        id: image1
        x: 0
        y: 43
        width: 100
        height: 100
        anchors.horizontalCenterOffset: 0
        anchors.horizontalCenter: parent.horizontalCenter
        source: "qrc:/LichViet.png"

        Text {
            id: text3
            x: 10
            y: 261
            width: 80
            height: 20
            text: "Chương trình có tham khảo thuật toán tính <br>Âm Lịch của tác giả Hồ Ngọc Đức.<br><a href='http://www.informatik.uni-leipzig.de/~duc/amlich/'>http://www.informatik.uni-leipzig.de/~duc/amlich/</a>"
            anchors.horizontalCenterOffset: 0
            anchors.horizontalCenter: parent.horizontalCenter
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 16
        }
    }

    Text {
        id: text1
        x: 11
        y: 171
        width: 80
        height: 20
        text: "Lịch Âm Việt Nam <br> OS: Maemo 5"
        anchors.horizontalCenterOffset: 1
        font.bold: true
        anchors.horizontalCenter: parent.horizontalCenter
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.pixelSize: 26
    }

    Text {
        id: text2
        x: 10
        y: 234
        width: 80
        height: 20
        text: "Phiên bản : 1.0.2-1-beta (25/08/2011)<br>\
Phát triển bởi : <a href='mailto:metacuong@gmail.com'>metacuong@gmail.com</a>"
anchors.horizontalCenterOffset: 0
wrapMode: Text.NoWrap
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignHCenter
        anchors.horizontalCenter: parent.horizontalCenter
        font.pixelSize: 24
    }


}

    ToolBarSingle { id: toolBar; height: 50;
        y: screen.height-78
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:
        {
            screen.state="mainscreen"
        }
    }

    transitions: [
        Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutBack } }
    ]
}
