/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

import "amlich-hnd.js" as AmLich
import "xemngaytotxau.js" as NTX

Item{
    Rectangle {
        id: rectangle1
        x: 0
        y: -5
        anchors.rightMargin: 0
        anchors.leftMargin: 0
        anchors.topMargin:30
        anchors.fill: parent; anchors.bottomMargin: 16
        visible: true
        opacity:0.9

        Component {
            id: listDelegate
            Item {
                height: lheight+5
                Rectangle {
                                 width:rectangle1.width-20;
                                 y:10;
                                 x:10
                                 height:lheight
                                 color: "#ffffff"
                                 radius: 8
                                 border.color: "#b57e8f"
                Column {
                    Text { x:5;y:50;text:name;color:"blue";    font.pixelSize: 20
                        font.family: "Tahoma" }
                    Text { x:5;y:50;text:getHD(idm) ;    font.pixelSize: 20
                        font.family: "Tahoma"}
                    }                anchors.bottomMargin: -10
                }
            }
        }




        ListModel {
                 id: listModel

                 ListElement {
                     lheight:55;idm:0;name: "";
                 }
                 ListElement {
                     lheight:30;idm:-1;name: "";
                 }
                 ListElement {
                     lheight:85;idm:1;name: "<b>Giờ Hoàng Đạo</b>";
                 }
                 ListElement {
                     lheight:55;idm:2;name: "<b>Tiết Khí</b>";
                 }
                ListElement {
                     lheight:55;idm:3;name: "<b>Nhị Thập Bát Tú</b>";
                 }
                ListElement {
                     lheight:80;idm:6;name: "<b>Các sao tốt</b>";
                 }
            /*    ListElement {
                     lheight:80;idm:7;name: "<b>Các sao xấu</b>";
                 }
                ListElement {
                     lheight:120;idm:5;name: "<b>Ngày Tốt/Xấu</b>";
                 }*/
         }



        ListView {
              id: listView
              anchors.fill: parent;anchors.topMargin: 0;anchors.leftMargin: 0; anchors.bottomMargin: 16
              model: listModel
              delegate: listDelegate
              focus: true
        }

    }

    ToolBarSingle { id: toolBar; height: 50;
        y: screen.height-78
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:
        {
            screen.state="mainscreen"
        }
    }

    function getHD(idm){
        NTX.test();
        switch(idm){
        case 0 : return AmLich.getTHU(screen.jd)+",ngày <b>"+screen.curDay+"</b> tháng <b>"+screen.curMonth+"</b> năm <b>"+screen.curYear+"</b><br>Ngày <b>"+screen.lunarDay+"</b> tháng <b>"+screen.lunarMonth+"</b> năm <b>"+screen.lunarYear+"</b> (<b>"+screen.lunarYearInt+"</b>)";break;
        case 1 : return screen.lunarGioHoangDao;break;
        case 2 : return screen.lunarTietKhi();break;
        case 3 : return NTX.sao(screen.curYear,AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear).jd - AmLich.getLunarDate(1,1,screen.curYear).jd);break;
        case 5 :  return NTX.luangiai(screen.curDay);break;
        case -1: return NTX.truc(screen.lunarMonth, screen.lunarDayCanChi, screen.lunarMonthCanChi);break;//"Là ngày: <b>Thiên Lao Hắc Đạo</b> Trực: <b>Định</b>"
        case 6: return NTX.cacsaotot(screen.lunarMonth, screen.lunarDayCanChi);break;
        case 7: return NTX.cacsaoxau(screen.lunarMonth, screen.lunarDayCanChi);break;
        }
    }

    transitions: [
        Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutBack } }
    ]
}
