#ifndef OUTPUT_H
#define OUTPUT_H

#include <QMainWindow>
#include <QtGui>
#include "settings.h"
#include "dialogverify.h"

class settings;
class DialogVerify;

namespace Ui {
    class output;
}

class output : public QMainWindow
{
    Q_OBJECT

public:
    explicit output(QWidget *parent = 0);
    ~output();

    void setTextEditMD5(QString data);
    void setTextEditSHA1(QString data);
    void setTextEditSHA224(QString data);
    void setTextEditSHA256(QString data);
    void setTextEditSHA384(QString data);
    void setTextEditSHA512(QString data);
    void setTextEditBase64(QString data);
    QString getTextEditMD5();
    QString getTextEditSHA1();
    QString getTextEditSHA224();
    QString getTextEditSHA256();
    QString getTextEditSHA384();
    QString getTextEditSHA512();
    QString getTextEditBASE64();
    void copyToClipboard(QString text);
    void deleteTab(int i);
    bool isTabDeleted(int i);
    void restoreTab(int i);


    void show() {
        if( !isVisible() ) {
#ifdef Q_WS_MAEMO_5
            this->setAttribute(Qt::WA_Maemo5StackedWindow);
            this->setWindowFlags( Qt::Window );
#endif
        }
        QMainWindow::show();
    }

private slots:
    void on_pushButtonMD5_clicked();

    void on_pushButtonSHA1_clicked();

    void on_pushButtonSHA256_clicked();

    void on_tabOutput_currentChanged(int index);

    void on_pushButtonSHA224_clicked();

    void on_pushButtonSHA384_clicked();

    void on_pushButtonSHA512_clicked();

    void on_pushButtonbase64_clicked();

    void on_actionVerify_triggered();

private:
    Ui::output *ui;
    settings* uiSettings;
    DialogVerify* uiVerify;
    static const int MD5 = 0;
    static const int SHA1 = 1;
    static const int SHA224 = 2;
    static const int SHA256 = 3;
    static const int SHA384 = 4;
    static const int SHA512 = 5;
    static const int BASE64 = 6;
};

#endif // OUTPUT_H
