#ifndef MAINHASHES_H
#define MAINHASHES_H

#include <QtCore>
#include <QMainWindow>
#include <QThread>
#include "calculations.h"
#include "dialog.h"
#include "settings.h"

namespace Ui {
    class MainHashes;
}

class output;

class MainHashes : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainHashes(QWidget *parent = 0);
    ~MainHashes();

    QString splitBase64(QString text);

private slots:
    void on_btnCalculateText_clicked();

    void on_textEditText_textChanged();

    void on_btnCalculatefile_clicked();

    void on_textEditFile_textChanged();

    void on_btnRandom_clicked();

    void on_btnSelectFile_clicked();

    void on_actionClean_triggered();

    void on_actionAbout_triggered();

    void on_actionSettings_triggered();

    void on_actionExit_triggered();



    void on_btnTextPaste_clicked();

protected Q_SLOTS:
    void onUpdateProgressBar(qint64 readed, qint64 size);
    void onUpdateLabel(QString text);
    void onHashDone(QString text, int numjob);
    void onFinished();

private:
    Ui::MainHashes *ui;
        output* ifaceOutput;
        settings* ifaceSettings;
        calculations* calculate;



        Dialog* dialog;

        static const int MD5 = 0;
        static const int SHA1 = 1;
        static const int SHA224 = 2;
        static const int SHA256 = 3;
        static const int SHA384 = 4;
        static const int SHA512 = 5;
        static const int BASE64 = 6;
};

#endif // MAINHASHES_H
