#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif

#include <QFileDialog>
#include "mainhashes.h"
#include "ui_mainhashes.h"
#include "output.h"


MainHashes::MainHashes(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainHashes)
{
    ui->setupUi(this);
    ifaceOutput = new output(this);
    ifaceSettings = new settings(this);
    calculate = new calculations(this);
    dialog = new Dialog;

#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

MainHashes::~MainHashes()
{
    delete ui;
}


void MainHashes::on_btnCalculateText_clicked()
{
    QString t = ui->textEditText->toPlainText();
    ui->btnTextPaste->setDisabled(true);

    if (ifaceSettings->isCheckBoxChecked(0)) {
        if (ifaceOutput->isTabDeleted(0))
            ifaceOutput->restoreTab(0);

        QString md5 = calculate->HashTextMD5(t);
        ifaceOutput->setTextEditMD5(md5);
    } else { ifaceOutput->deleteTab(0); }

    if (ifaceSettings->isCheckBoxChecked(1)) {
        if (ifaceOutput->isTabDeleted(1))
            ifaceOutput->restoreTab(1);

        QString sha1 = calculate->HashTextSHA1(t);
        ifaceOutput->setTextEditSHA1(sha1);
    } else { ifaceOutput->deleteTab(1); }

    if (ifaceSettings->isCheckBoxChecked(2)) {
        if (ifaceOutput->isTabDeleted(2))
            ifaceOutput->restoreTab(2);

        QString sha224 = calculate->HashTextSHA224(t);
        ifaceOutput->setTextEditSHA224(sha224);
    } else { ifaceOutput->deleteTab(2); }

    if (ifaceSettings->isCheckBoxChecked(3)) {
        if (ifaceOutput->isTabDeleted(3))
            ifaceOutput->restoreTab(3);

        QString sha256 = calculate->HashTextSHA256(t);
        ifaceOutput->setTextEditSHA256(sha256);
    } else { ifaceOutput->deleteTab(3); }

    if (ifaceSettings->isCheckBoxChecked(4)) {
        if (ifaceOutput->isTabDeleted(4))
            ifaceOutput->restoreTab(4);

        QString sha384 = calculate->HashTextSHA384(t);
        ifaceOutput->setTextEditSHA384(sha384);
    } else { ifaceOutput->deleteTab(4); }

    if (ifaceSettings->isCheckBoxChecked(5)) {
        if (ifaceOutput->isTabDeleted(5))
            ifaceOutput->restoreTab(5);

        QString sha512 = calculate->HashTextSHA512(t);
        ifaceOutput->setTextEditSHA512(sha512);
    } else { ifaceOutput->deleteTab(5); }

    if (ifaceSettings->isCheckBoxChecked(6)) {
        if (ifaceOutput->isTabDeleted(6))
            ifaceOutput->restoreTab(6);

        QString base64 = calculate->HashTextBase64(t);
        ifaceOutput->setTextEditBase64(base64);
    } else { ifaceOutput->deleteTab(6); }

    ui->btnTextPaste->setEnabled(true);
    ifaceOutput->show();
}

void MainHashes::on_textEditText_textChanged()
{
    QString text = ui->textEditText->toPlainText();
    if (text.isEmpty()) {
        ui->btnCalculateText->setEnabled(false);
    }
    else {
        ui->btnCalculateText->setEnabled(true);
    }
}

void MainHashes::on_btnCalculatefile_clicked()
{
    QThread* thread = new QThread;
    calculations* calc = new calculations;

    connect(calc, SIGNAL(hashDone(QString,int)), this, SLOT(onHashDone(QString, int)));
    connect(calc, SIGNAL(updateProgressBar(qint64,qint64)), this, SLOT(onUpdateProgressBar(qint64,qint64)));
    connect(calc, SIGNAL(updateLabel(QString)), this, SLOT(onUpdateLabel(QString)));
    connect(ui->btnCancel, SIGNAL(clicked()), calc, SLOT(canceljob()), Qt::DirectConnection);
    connect(calc, SIGNAL(finished()), thread, SLOT(quit()));
    connect(thread, SIGNAL(finished()), thread, SLOT(deleteLater()));
    connect(thread, SIGNAL(finished()), this, SLOT(onFinished()));
    QFileInfo f(ui->textEditFile->toPlainText());
    if (!f.exists())
        ui->labelInfo->setText("File missing!");
    else
    {
        ui->btnCalculatefile->setDisabled(true);
        ui->btnCancel->setEnabled(true);
        ui->btnSelectFile->setDisabled(true);

        QString t = ui->textEditFile->toPlainText();
        if (ifaceSettings->isCheckBoxChecked(MD5)) {
            if (ifaceOutput->isTabDeleted(MD5))
                ifaceOutput->restoreTab(MD5);

            calc->setJob(*thread, MD5, t);
        } else { ifaceOutput->deleteTab(MD5); }

        if (ifaceSettings->isCheckBoxChecked(SHA1)) {
            if (ifaceOutput->isTabDeleted(SHA1))
                ifaceOutput->restoreTab(SHA1);

            calc->setJob(*thread, SHA1, t);
        } else { ifaceOutput->deleteTab(SHA1); }

        if (ifaceSettings->isCheckBoxChecked(SHA224)) {
            if (ifaceOutput->isTabDeleted(SHA224))
                ifaceOutput->restoreTab(SHA224);

            calc->setJob(*thread, SHA224, t);
        } else { ifaceOutput->deleteTab(SHA224); }

        if (ifaceSettings->isCheckBoxChecked(SHA256)) {
                ifaceOutput->restoreTab(SHA256);

            calc->setJob(*thread, SHA256, t);
        } else { ifaceOutput->deleteTab(SHA256); }

        if (ifaceSettings->isCheckBoxChecked(SHA384)) {
            if (ifaceOutput->isTabDeleted(SHA384))
                ifaceOutput->restoreTab(SHA384);

            calc->setJob(*thread, SHA384, t);
        } else { ifaceOutput->deleteTab(SHA384); }

        if (ifaceSettings->isCheckBoxChecked(SHA512)) {
            if (ifaceOutput->isTabDeleted(SHA512))
                ifaceOutput->restoreTab(SHA512);

            calc->setJob(*thread, SHA512, t);
        } else { ifaceOutput->deleteTab(SHA512); }

        if (ifaceSettings->isCheckBoxChecked(BASE64)) {
            if (ifaceOutput->isTabDeleted(BASE64))
                ifaceOutput->restoreTab(BASE64);

            calc->setJob(*thread, BASE64, t);
        } else { ifaceOutput->deleteTab(BASE64); }
        calc->moveToThread(thread);
        thread->start(QThread::LowPriority);
    }
}

void MainHashes::on_textEditFile_textChanged()
{
    QString text = ui->textEditFile->toPlainText();
    if (text.isEmpty()) {
        ui->btnCalculatefile->setEnabled(false);
    }
    else {
        ui->btnCalculatefile->setEnabled(true);
    }
    ui->labelInfo->setText("");
}

void MainHashes::on_btnRandom_clicked()
{
    QTime time = QTime::currentTime();
    qsrand((uint)time.msec());
    int rand = 0;
    QString string = "";

    for (int count=1; count<=ui->spinBox->value();count++)
    {
        rand = calculate->randomBetween(48,125);
        string+=rand;
    }
    ui->textEditText->setText(string);
}

void MainHashes::on_btnSelectFile_clicked()
{
    QString filter;
    QFileDialog fd;
    fd.setDirectory("/home/user");
    QString fileName = fd.getOpenFileName(this, trUtf8(""),
                                           ui->textEditFile->toPlainText(),
                                           trUtf8("All Files (*)"),
                                           &filter, 0);
    ui->textEditFile->setText(fileName);
}

void MainHashes::on_actionClean_triggered()
{
    ui->textEditFile->clear();
    ui->textEditText->clear();
}

void MainHashes::on_actionAbout_triggered()
{
    dialog->setTitle("About lhc");
    dialog->setTxt("Little Hash Calculator (lhc)<br>"
                   "<br>"
                   "Version: 0.5<br>"
                   "Author: Drexxx");

    dialog->show();
}

void MainHashes::on_actionSettings_triggered()
{
    ifaceSettings->show();
}

QString MainHashes::splitBase64(QString text)
{
    int limit = ifaceSettings->getSpinBoxValue();

    QStringList splitted;
    QString result;
    while (text.length() > 1)
    {
        splitted.append(text.left(limit));
        text.remove(0,limit);
    }
    result = splitted.join("\n");
    return result;
}

void MainHashes::on_actionExit_triggered()
{
    destroy(true, true);
    exit(0);
}

void MainHashes::onUpdateProgressBar(qint64 readed, qint64 size)
{
    ui->progressBar->setValue(readed*100/size);
}

void MainHashes::onUpdateLabel(QString text)
{
    ui->labelInfo->setText(text);
}

void MainHashes::onHashDone(QString text, int numjob)
{
    qDebug() << "onhashdone job " << numjob;
    switch(numjob)
    {
    case MD5:
        ifaceOutput->setTextEditMD5(text);
        break;
    case SHA1:
        ifaceOutput->setTextEditSHA1(text);
        break;
    case SHA224:
        ifaceOutput->setTextEditSHA224(text);
        break;
    case SHA256:
        ifaceOutput->setTextEditSHA256(text);
        break;
    case SHA384:
        ifaceOutput->setTextEditSHA384(text);
        break;
    case SHA512:
        ifaceOutput->setTextEditSHA512(text);
        break;
    case BASE64:
        text = splitBase64(text);
        ifaceOutput->setTextEditBase64(text);
        break;
    default:
        break;
    }
}

void MainHashes::onFinished()
{
    qDebug() << "Thread finished";
    ui->btnCancel->setDisabled(true);
    ui->btnCalculatefile->setEnabled(true);
    ui->btnSelectFile->setEnabled(true);
    ifaceOutput->show();
}

void MainHashes::on_btnTextPaste_clicked()
{
    QClipboard *clipboard = QApplication::clipboard();
    QString TextToPaste = clipboard->text();
    ui->textEditText->setText(TextToPaste);
}
