#ifndef CALCULATIONS_H
#define CALCULATIONS_H

#include <QObject>
#include <QtCrypto>

class MainHashes;

class calculations : public QObject
{
    Q_OBJECT
public:
    explicit calculations(QObject *parent = 0);

    QString HashTextMD5(QString text);
    QString HashTextSHA1(QString text);
    QString HashTextSHA224(QString text);
    QString HashTextSHA256(QString text);
    QString HashTextSHA384(QString text);
    QString HashTextSHA512(QString text);
    QString HashTextBase64(QString text);

    void setJob(QThread &thread, int numJob, QString name);

    int randomBetween(int low, int high);

Q_SIGNALS:
    void hashDone(QString hash, int job);
    void updateProgressBar(qint64 totalreaded, qint64 filesize);
    void updateLabel(QString text);
    void canceled();
    void finished();

protected Q_SLOTS:
    void HashFileMD5();
    void HashFileSHA1();
    void HashFileSHA224();
    void HashFileSHA256();
    void HashFileSHA384();
    void HashFileSHA512();
    void HashFileBase64();
    void canceljob();

protected:

private:
    MainHashes* ifaceMain;
    QString filename;
    volatile bool stop;
    static const int MD5 = 0;
    static const int SHA1 = 1;
    static const int SHA224 = 2;
    static const int SHA256 = 3;
    static const int SHA384 = 4;
    static const int SHA512 = 5;
    static const int BASE64 = 6;
};

#endif // CALCULATIONS_H
