#include "output.h"
#include "ui_output.h"

output::output(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::output)
{
    ui->setupUi(this);

#ifdef Q_WS_MAEMO_5
        this->setAttribute(Qt::WA_Maemo5StackedWindow);
        this->setWindowFlags(Qt::Window);
#endif
}

output::~output()
{
    delete ui;
}

void output::setTextEditMD4(QString data)
{
    ui->textEditMD4->setText(data);
}

void output::setTextEditMD5(QString data)
{
    ui->textEditMD5->setText(data);
}

void output::setTextEditSHA1(QString data)
{
    ui->textEditSHA1->setText(data);
}

void output::on_pushButtonMD4_clicked()
{
    copyToClipboard(ui->textEditMD4->toPlainText());
}

void output::on_pushButtonMD5_clicked()
{
    copyToClipboard(ui->textEditMD5->toPlainText());
}

void output::on_pushButtonSHA1_clicked()
{
    copyToClipboard(ui->textEditSHA1->toPlainText());
}

void output::copyToClipboard(QString textToCopy)
{
    QClipboard *clipboard = QApplication::clipboard();
    clipboard->setText(textToCopy);
    ui->labelCopied->setText("String copied");
}


void output::on_tabOutput_currentChanged(int index)
{
    ui->labelCopied->clear();
}
