#include <QtCore>
#include <QtGui>

#include <QFileDialog>
#include <QFileInfo>
#include <QDialog>


#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif

#include "mainhashes.h"
#include "ui_mainhashes.h"
#include "output.h"
#include "calculations.h"
#include "dialog.h"

MainHashes::MainHashes(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainHashes)
{
    ui->setupUi(this);
    ifaceOutput = new output(this);
    calculate = new calculations(this);
    dialog = new Dialog;

#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

MainHashes::~MainHashes()
{
    delete ui;
}


void MainHashes::on_btnCalculateText_clicked()
{
    QString t = ui->textEditText->toPlainText();
    QString md4 = calculate->HashTextMD4(t);
    QString md5 = calculate->HashTextMD5(t);
    QString sha1 = calculate->HashTextSHA1(t);

    ifaceOutput->setTextEditMD4(md4);
    ifaceOutput->setTextEditMD5(md5);
    ifaceOutput->setTextEditSHA1(sha1);
    ifaceOutput->show();
}

void MainHashes::on_textEditText_textChanged()
{
    QString text = ui->textEditText->toPlainText();
    if (text.isEmpty()) {
        ui->btnCalculateText->setEnabled(false);
    }
    else {
        ui->btnCalculateText->setEnabled(true);
    }
}

void MainHashes::on_btnCalculatefile_clicked()
{
    QFileInfo f(ui->textEditFile->toPlainText());
    if (!f.exists())
    {
        ui->labelInfoFile->setText("File missing!");
    }
    else
    {
        ui->labelInfoFile->setText("File exist");
        QString t = ui->textEditFile->toPlainText();
        QString md4 = calculate->HashFileMD4(t);
        QString md5 = calculate->HashFileMD5(t);
        QString sha1 = calculate->HashFileSHA1(t);

        ifaceOutput->setTextEditMD4(md4);
        ifaceOutput->setTextEditMD5(md5);
        ifaceOutput->setTextEditSHA1(sha1);
        ifaceOutput->show();
    }
}

void MainHashes::on_textEditFile_textChanged()
{
    QString text = ui->textEditFile->toPlainText();
    if (text.isEmpty()) {
        ui->btnCalculatefile->setEnabled(false);
    }
    else {
        ui->btnCalculatefile->setEnabled(true);
    }
    ui->labelInfoFile->setText("");
}

void MainHashes::on_btnRandom_clicked()
{
    QTime time = QTime::currentTime();
    qsrand((uint)time.msec());
    int rand = 0;
    QString string = "";

    for (int count=1; count<=ui->spinBox->value();count++)
    {
        rand = calculate->randomBetween(48,125);
        string+=rand;
    }
    ui->textEditText->setText(string);
}

void MainHashes::on_btnSelectFile_clicked()
{
    QString filter;
    QFileDialog fd;
    fd.setDirectory("/home/user");
    QString fileName = fd.getOpenFileName(this, trUtf8(""),
                                           ui->textEditFile->toPlainText(),
                                           trUtf8("All Files (*)"),
                                           &filter, 0);
    ui->textEditFile->setText(fileName);
}

void MainHashes::on_actionClean_triggered()
{
    ui->textEditFile->clear();
    ui->textEditText->clear();
}

void MainHashes::on_actionAbout_triggered()
{
    dialog->setTitle("About lhc");
    dialog->setTxt("Little Hash Calculator (lhc)<br>"
                   "<br>"
                   "Version: 0.0.1<br>"
                   "Author: Drexxx");

    dialog->show();
}
