#include <QByteArray>
#include <QCryptographicHash>
#include <QFile>
#include "calculations.h"

calculations::calculations(QObject *parent) :
    QObject(parent)
{
}

QString calculations::HashTextMD4(QString name)
{
    QString str(name);
    QByteArray hash = QCryptographicHash::hash(str.toUtf8(), QCryptographicHash::Md4);
    QString datareturn(hash.toHex());
    return datareturn;
}

QString calculations::HashTextMD5(QString name)
{
    QString str(name);
    QByteArray hash = QCryptographicHash::hash(str.toUtf8(), QCryptographicHash::Md5);
    QString datareturn(hash.toHex());
    return datareturn;
}

QString calculations::HashTextSHA1(QString name)
{
    QString str(name);
    QByteArray hash = QCryptographicHash::hash(str.toUtf8(), QCryptographicHash::Sha1);
    QString datareturn(hash.toHex());
    return datareturn;
}

QString calculations::HashFileMD4(QString name)
{
    QFile file(name);
    if (file.open(QIODevice::ReadOnly))
    {
        QByteArray fileData = file.readAll();

        QByteArray md4sum = QCryptographicHash::hash(fileData,QCryptographicHash::Md4);
        file.close();
        QString datareturn(md4sum.toHex());
        return datareturn;
     }
    else return "";
}

QString calculations::HashFileMD5(QString name)
{
    QFile file(name);
    if (file.open(QIODevice::ReadOnly))
    {
        QByteArray fileData = file.readAll();

        QByteArray md5sum = QCryptographicHash::hash(fileData,QCryptographicHash::Md5);
        file.close();
        QString datareturn(md5sum.toHex());
        return datareturn;
     }
    else return "";
}

QString calculations::HashFileSHA1(QString name)
{
    QFile file(name);
    if (file.open(QIODevice::ReadOnly))
    {
        QByteArray fileData = file.readAll();

        QByteArray sha1sum = QCryptographicHash::hash(fileData,QCryptographicHash::Sha1);
        file.close();
        QString datareturn(sha1sum.toHex());
        return datareturn;
     }
    else return "";
}

int calculations::randomBetween(int min, int max)
{
    return qrand() % ((max + 1) - min) + min;
}
