#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
###########################################################################
## Name: 	       Leo
## Description:
## Copyright:     George Ruinelli, george@ruinelli.ch
## Licence:        GPL
###########################################################################

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import os, sys

from qwebviewselectionsuppressor import QWebViewSelectionSuppressor

import data

## INIT ###################################
#app path has to be set first
data.app_path=os.path.dirname(__file__)
if(data.app_path==""): data.app_path="./"
else: data.app_path=data.app_path+"/"

print "Leo"

#app path has to be set first
data.app_path=os.path.dirname(__file__)
if(data.app_path==""): data.app_path="./"
else: data.app_path=data.app_path+"/"

#Load version file
try:
    file = open(data.app_path+"version", 'r')
    data.version = file.readline()
    data.version=data.version[:-1]
    data.build = file.readline()
    print "Version: "+str(data.version)+ "-"+str(data.build)
except:
    print "Version file not found, please check your installation!"


########################################

#GUIs
from Ui_StartWindow import *


###########################################################################
## Main function
##############o#############################################################
def main():
    global app,  StartWindow

    app = QApplication(sys.argv)

    data.demo=True

    StartWindow = frmStartWindow()
    StartWindow.show()

#    app.processEvents() #force ui update

    StartWindow.start()

    sys.exit(app.exec_())











###########################################################################
##  Class for Main Window
###########################################################################
class frmStartWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self)
#        if(data.demo==False): self.setAttribute(Qt.WA_Maemo5StackedWindow) # This attribute makes the whole Stacked Window thing work
        self.ui = Ui_StartWindow()
        self.ui.setupUi(self)

        # remove selection when clic/drag to enable finger scrolling
        self.suppressor = QWebViewSelectionSuppressor(self.ui.webView)
        self.suppressor.enable()
        try:
            scroller = self.ui.webView.property("kineticScroller").toPyObject()
            if scroller:
                scroller.setEnabled(True)
        except:
            pass

        self.ui.webView.page().mainFrame().setScrollBarPolicy(QtCore.Qt.Vertical, QtCore.Qt.ScrollBarAlwaysOn)

        #QCleanlooksStyle
#        app.setStyle('cleanlooks')

        QtCore.QObject.connect(self.ui.webView,QtCore.SIGNAL("loadProgress (int)"), self.load_progress)
        QtCore.QObject.connect(self.ui.webView,QtCore.SIGNAL("loadStarted ()"), self.load_started)
        QtCore.QObject.connect(self.ui.webView,QtCore.SIGNAL("loadFinished (bool)"), self.load_finished)
        QtCore.QObject.connect(self.ui.webView,QtCore.SIGNAL("selectionChanged ()"), self.selectionChanged)
        QtCore.QObject.connect(self.ui.webView,QtCore.SIGNAL("titleChanged (const QString&)"), self.titleChanged)


        QtCore.QObject.connect(self.ui.actionStart_page, QtCore.SIGNAL("triggered()"), self.start)
        QtCore.QObject.connect(self.ui.actionBack, QtCore.SIGNAL("triggered()"), self.back)
        QtCore.QObject.connect(self.ui.actionNext, QtCore.SIGNAL("triggered()"), self.next)
        QtCore.QObject.connect(self.ui.actionStop, QtCore.SIGNAL("triggered()"), self.stop)
        QtCore.QObject.connect(self.ui.actionReload, QtCore.SIGNAL("triggered()"), self.reload)
        QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL("triggered()"), self.about)
        QtCore.QObject.connect(self.ui.actionAbout_dict_leo_org, QtCore.SIGNAL("triggered()"), self.about_dict_leo_org)





    def start(self):
        self.ui.webView.setUrl(QtCore.QUrl(data.url))


    def load_progress(self, load):
        global app
        print  load
        self.ui.lblStatus.setText("Loading... ("+str(load)+"%)")
        self.ui.lblProgressbar.setGeometry(QtCore.QRect(0, 390, load*8, 31))



    def load_started(self):
        print "load_started"
        self.ui.lblProgressbar.setGeometry(QtCore.QRect(0, 390, 0, 31))
        self.ui.lblProgressbar.show()
        self.ui.lblStatus.show()



    def load_finished(self, success):
        print "load_finished, status:", success
        self.ui.lblProgressbar.hide()
        self.ui.lblStatus.hide()

        #scroll down
        url=str(self.ui.webView.url().toString())
        print url
#        if(url==data.url+"/"): #start page
        if(url==data.url): #start page
            print "Main page"
#            self.ui.webView.page().mainFrame().setScrollPosition(QPoint(0,171))
            self.ui.webView.page().mainFrame().setScrollPosition(QPoint(0,0))
        else:
            print "Result page"
            self.ui.webView.page().mainFrame().setScrollPosition(QPoint(0,405))





    def selectionChanged(self):
        print "selectionChanged"


    def titleChanged(self, title):
#        print "titleChanged:", title
#        self.setWindowTitle(QtGui.QApplication.translate("", title, None, QtGui.QApplication.UnicodeUTF8))
        pass



    def stop(self):
        self.ui.webView.stop()




    def reload(self):
        self.ui.webView.reload()




#    def link_clicked(self, url):
#        page = self.ui.webView.page()
#        history = page.history()
#        if history.canGoBack():
#            self.ui.back.setEnabled(True)
#        else:
#            self.ui.back.setEnabled(False)
#        if history.canGoForward():
#            self.ui.next.setEnabled(True)
#        else:
#            self.ui.next.setEnabled(False)
#
#        self.ui.url.setText(url.toString())


    def back(self):
        page = self.ui.webView.page()
        history = page.history()
        history.back()
        if history.canGoBack():
            self.ui.back.setEnabled(True)
        else:
            self.ui.back.setEnabled(False)




    def next(self):
        page = self.ui.webView.page()
        history = page.history()
        history.forward()
        if history.canGoForward():
            self.ui.next.setEnabled(True)
        else:
            self.ui.next.setEnabled(False)




    def about(self):
        QtGui.QMessageBox.about(self, "About", "Copyright 2010 by George Ruinelli\n"+\
        "Version:"+" "+str(data.version)+"-"+str(data.build)+"\n"+\
        "Contact:"+" george@ruinelli.ch\n" +\
        "Website:"+" http://www.ruinelli.ch/leo/\n\n"+\
        "Feedback and donations are very welcome!")



    def about_dict_leo_org(self):
        QtGui.QMessageBox.about(self, "About dict.leo.org", "Responsible for the contents of the domain leo.org:\n" +\
        "LEO GmbH\n" +\
        "Muehlweg 2b\n" +\
        "82054 Sauerlach\n" +\
        "Germany\n\n" +\
        "LEO GmbH is registered in Munich, Germany, No. HRB161107\n" +\
        "Responsible under Para. 10 Section 3 MDStV:\n" +\
        "Hans (Kili) Riethmayer, Muehlweg 2b, 82054 Sauerlach")
#        print data.url_about_leo
#        self.ui.webView.setUrl(QtCore.QUrl(data.url_about_leo))




###########################################################################
main() # Now we can start it.
