try:
    from lxml import etree
    print("running with lxml.etree")
except ImportError:
    try:
    # Python 2.5
        import xml.etree.cElementTree as etree
        print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # Python 2.5
            import xml.etree.ElementTree as etree
            print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree
                print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree
                    print("running with ElementTree")
                except ImportError:
                    print("Failed to import ElementTree from any known place")


class Lang:
    #def __init__(self):
    
    def has_attrib(self, elem, attrib):
        try:
            elem.attrib[attrib]
        except:
            return False
        return True

    def country_names(self, region, country_codes, lang):
        dict = {}
        try:
            doc = etree.iterparse("res/names/" + region + ".xml")
        except:
            doc = etree.iterparse("/opt/leif/src/res/names/" + region + ".xml")
        for action, elem in doc:
            if self.has_attrib(elem, "code"):
                parent = elem.getparent()
                if parent.get('lang') == lang:
                    #print elem.text
                    #list.append(elem.text)
                    dict[elem.get('code')] = elem.text
                #print elem.text
        return dict

