from xml.etree.ElementTree import parse
import re
import cairo

class SVG(object):
    def __init__(self, filename):
        self.i = 0
        #self.cr = Context
        self.currcountry = []
        #self.currcountry = {}
        #self.country = ""
        self.filename = filename
        f = open(filename, 'r')
        self.tree = parse(f)
        self.parse_doc()
        #n_vertices = sum(len(x) for x in self.paths)
        #global total_vertices
        #total_vertices += n_vertices

    def parse_float(self, txt):
        if txt.endswith('px'):
            return float(txt[:-2])
        else:
            return float(txt)
    def parse_doc(self):
        self.paths = []
        self.width = self.parse_float(self.tree._root.get("width"))
        self.height = self.parse_float(self.tree._root.get("height"))
        for e in self.tree.getiterator():
            if e.tag.endswith('path'):
                self.pathdata = e.get('d')
                self.country = e.get('id')
                #print self.currcountry
                if not self.pathdata:
                    continue
                self.pathdata = re.findall("([A-Za-z]|-?[0-9]+\.?[0-9]*(?:e-?[0-9]*)?)", self.pathdata)
                #print self.pathdata

                def pnext():
                    return (float(self.pathdata.pop(0)), self.height - float(self.pathdata.pop(0)))
                self.new_path()
                while self.pathdata:
                    opcode = self.pathdata.pop(0)
                    if opcode == 'M':
                        self.end_path(self.country)
                        self.new_path()
                        self.set_position(*pnext())
                    elif opcode == 'C':
                        self.curve_to(*(pnext() + pnext() + pnext()))
                    elif opcode == 'c':
                        mx = self.x
                        my = self.y
                        x1, y1 = pnext()
                        x2, y2 = pnext()
                        x, y = pnext()
                        y1 = self.height - y1
                        y2 = self.height - y2
                        y = self.height - y
                        self.curve_to(mx + x1, my - y1, mx + x2, my - y2, mx + x, my - y)
                    elif opcode == 'z':
                        self.line_to(*(self.path[0:2]))
                    elif opcode == 'L':
                        self.line_to(*pnext())
                    else:
                        print self.filename, " - Warning, unrecognised opcode:", opcode
                self.end_path(self.country)
            elif e.tag.endswith('rect'):
                x = float(e.get('x'))
                y = self.height - float(e.get('y'))
                h = float(e.get('height'))
                w = float(e.get('width'))
                self.new_path()
                self.set_position(x, y)
                self.line_to(x+w,y)
                self.line_to(x+w,y-h)
                self.line_to(x,y-h)
                self.line_to(x,y)
                self.end_path(self.country)
    def new_path(self):
        self.x = 0
        self.y = 0
        self.path = []
        
    def set_position(self, x, y):
        self.x = x
        self.y = y
        self.path.append([x,y])
        #print self.path
        #self.cr.move_to(x,self.height-y);

    def curve_to(self, x1, y1, x2, y2, x, y):
        pass
            
    def line_to(self, x, y):
        #print x, y;
        #self.cr.line_to(x,self.height-y);
        self.set_position(x,y)
        
    def end_path(self,country):
        self.path.append(country)
        self.paths.append(self.path)

    def get_country_codes(self):
        for e in self.tree.getiterator():
            if e.tag.endswith('path'):
                #if len(e.get('id')) <= 3:
                self.currcountry.append(e.get('id'))
        return self.currcountry

    
    def render(self, cr, country, offset, zoom):
        for path in self.paths:
            for p in path:
                 #print p[len(p)-1]
                try:
                    if path[len(path)-1] == country:
                        cr.line_to(zoom*(p[0]-offset[0]), zoom*(self.height-p[1]-offset[1]))
                except: #end of the path!
                    if path[len(path)-1] == country:
                        cr.close_path()

    #def render(self, cr, country):
        #print self.currcountry, "hehe"
        #print self.currcountry[country]
        #print self.paths[country][len(self.paths[country])-1]
     #   for p in self.paths:
            #print p[len(p)-1]
      #      try:
                #print self.paths[self.currcountry[country]][len(self.paths[self.currcountry[country]])-1], self.currcountry[country]
                
       #         if self.paths[country][len(self.paths[country])-1] == self.currcountry[country]:
                    #print self.paths[country][len(self.paths[country])-1]
                    #print self.currcountry[country]
                    #cr.line_to(p[0], self.height-p[1])
        #    except: #end of the path!
         #      pass
                #if self.paths[country][len(self.paths[country])-1] == self.currcountry[country]:
                 #   cr.close_path()


    def collides(self, cr, (x,y)):
        if cr.in_fill(x,y):
            return True
        return False
        
