/*
 *  ledpulse for the maemo desktop.
 *  Copyright (C) 2013 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "ledpulse-settings.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <gconf/gconf-client.h>
#include <stdlib.h>

#define GCONF_PATH "/apps/maemo/ledpulse"
#define GCONF_PATH_RED_LED GCONF_PATH "/red_led"
#define GCONF_PATH_BLUE_LED GCONF_PATH "/blue_led"
#define GCONF_PATH_GREEN_LED GCONF_PATH "/green_led"
#define GCONF_PATH_KB1_LED GCONF_PATH "/keyboard1_led"
#define GCONF_PATH_KB2_LED GCONF_PATH "/keyboard2_led"
#define GCONF_PATH_KB3_LED GCONF_PATH "/keyboard3_led"
#define GCONF_PATH_KB4_LED GCONF_PATH "/keyboard4_led"
#define GCONF_PATH_KB5_LED GCONF_PATH "/keyboard5_led"
#define GCONF_PATH_KB6_LED GCONF_PATH "/keyboard6_led"
#define GCONF_PATH_SOURCE GCONF_PATH "/source"

void ledpulse_settings_load(LedPulseSettings* settings)
{
  GConfClient* gconf = gconf_client_get_default();
  settings->red_led = gconf_client_get_bool(gconf, GCONF_PATH_RED_LED, NULL);
  settings->blue_led = gconf_client_get_bool(gconf, GCONF_PATH_BLUE_LED, NULL);
  settings->green_led = gconf_client_get_bool(gconf, GCONF_PATH_GREEN_LED, NULL);
  settings->kb1_led = gconf_client_get_bool(gconf, GCONF_PATH_KB1_LED, NULL);
  settings->kb2_led = gconf_client_get_bool(gconf, GCONF_PATH_KB2_LED, NULL);
  settings->kb3_led = gconf_client_get_bool(gconf, GCONF_PATH_KB3_LED, NULL);
  settings->kb4_led = gconf_client_get_bool(gconf, GCONF_PATH_KB4_LED, NULL);
  settings->kb5_led = gconf_client_get_bool(gconf, GCONF_PATH_KB5_LED, NULL);
  settings->kb6_led = gconf_client_get_bool(gconf, GCONF_PATH_KB6_LED, NULL);
  if(settings->source)
    g_free(settings->source);
  settings->source = gconf_client_get_string(gconf, GCONF_PATH_SOURCE, NULL);
  g_object_unref(gconf);
}

void ledpulse_settings_save(LedPulseSettings* settings)
{
  GConfClient* gconf = gconf_client_get_default();
  gconf_client_set_bool(gconf, GCONF_PATH_RED_LED,settings->red_led, NULL);
  gconf_client_set_bool(gconf, GCONF_PATH_BLUE_LED,settings->blue_led, NULL);
  gconf_client_set_bool(gconf, GCONF_PATH_GREEN_LED,settings->green_led, NULL);
  gconf_client_set_bool(gconf, GCONF_PATH_KB1_LED,settings->kb1_led, NULL);
  gconf_client_set_bool(gconf, GCONF_PATH_KB2_LED,settings->kb2_led, NULL);
  gconf_client_set_bool(gconf, GCONF_PATH_KB3_LED,settings->kb3_led, NULL);
  gconf_client_set_bool(gconf, GCONF_PATH_KB4_LED,settings->kb4_led, NULL);
  gconf_client_set_bool(gconf, GCONF_PATH_KB5_LED,settings->kb5_led, NULL);
  gconf_client_set_bool(gconf, GCONF_PATH_KB6_LED,settings->kb6_led, NULL);
  gconf_client_set_string(gconf, GCONF_PATH_SOURCE,settings->source, NULL);
  g_object_unref(gconf);
}

LedPulseSettings* ledpulse_settings_create() {
  LedPulseSettings* settings = (LedPulseSettings*)g_malloc0(sizeof(LedPulseSettings));
  settings->source = g_strdup("Monitor");
  settings->red_led = TRUE;
  return settings;
}
