/*
 *  Copyright (C) 2013 Nicolai Hess
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LEDPULSE_LED_FILES_H
#define LEDPULSE_LED_FILES_H
#include "ledpulse-settings.h"
#include <stdio.h>

#define RED_LED_FILE "/sys/class/leds/lp5523:r/brightness"
#define GREEN_LED_FILE "/sys/class/leds/lp5523:g/brightness"
#define BLUE_LED_FILE "/sys/class/leds/lp5523:b/brightness"
#define KB1_LED_FILE "/sys/class/leds/lp5523:kb1/brightness"
#define KB2_LED_FILE "/sys/class/leds/lp5523:kb2/brightness"
#define KB3_LED_FILE "/sys/class/leds/lp5523:kb3/brightness"
#define KB4_LED_FILE "/sys/class/leds/lp5523:kb4/brightness"
#define KB5_LED_FILE "/sys/class/leds/lp5523:kb5/brightness"
#define KB6_LED_FILE "/sys/class/leds/lp5523:kb6/brightness"

typedef struct _LedFileDescriptors {
  FILE* red_led_file;
  FILE* blue_led_file;
  FILE* green_led_file;
  FILE* kb1_led_file;
  FILE* kb2_led_file;
  FILE* kb3_led_file;
  FILE* kb4_led_file;
  FILE* kb5_led_file;
  FILE* kb6_led_file;
} LedFileDescriptors;

void ledpulse_led_files_write_to_leds(LedFileDescriptors* led_files, LedPulseSettings* settings, int data);
void ledpulse_led_files_close_leds(LedFileDescriptors* led_files);
void ledpulse_led_files_open_from(LedFileDescriptors* led_files, LedPulseSettings* settings);
LedFileDescriptors* ledpulse_led_files_create();

#endif
