/*
 *  Copyright (C) 2013 Nicolai Hess
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LEDPULSE_HOME_PLUGIN_H
#define LEDPULSE_HOME_PLUGIN_H

#include <libhildondesktop/libhildondesktop.h>
#include "ledpulse-settings.h"

G_BEGIN_DECLS

#define LEDPULSE_TYPE_HOME_PLUGIN         (ledpulse_home_plugin_get_type ())
#define LEDPULSE_HOME_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_CAST((obj), LEDPULSE_TYPE_HOME_PLUGIN, LedPulseHomePlugin))
#define LEDPULSE_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), LEDPULSE_TYPE_HOME_PLUGIN, LedPulseHomePluginClass))
#define LEDPULSE_IS_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LEDPULSE_TYPE_HOME_PLUGIN))
#define LEDPULSE_ISHOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LEDPULSE_TYPE_HOME_PLUGIN))
#define LEDPULSE_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), LEDPULSE_TYPE_HOME_PLUGIN, LedPulseHomePluginClass))

typedef struct _LedPulseHomePlugin        LedPulseHomePlugin;
typedef struct _LedPulseHomePluginPrivate LedPulseHomePluginPrivate;
typedef struct _LedPulseHomePluginClass   LedPulseHomePluginClass;

struct _LedPulseHomePlugin
{
  HDHomePluginItem parent;
  LedPulseHomePluginPrivate *priv;
  LedPulseSettings* settings;
};

struct _LedPulseHomePluginClass
{
  HDHomePluginItemClass parent;
};

void ledpulse_home_plugin_reload_settings(LedPulseHomePlugin* plugin);
void ledpulse_home_plugin_process_audio_data(LedPulseHomePlugin* plugin, const void*, size_t nbytes);
GType ledpulse_home_plugin_get_type(void) G_GNUC_CONST;

G_END_DECLS
#endif
