/* This file is part of LED Pattern Editor.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * LED Pattern Editor is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LED Pattern Editor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LED Pattern Editor. If not, see <http://www.gnu.org/licenses/>.
 */

public static Osso.Status execute (Osso.Context osso, void* data, bool user_activated) {
	var window = data as Gtk.Window;

	// Gettext hook-up
	Intl.setlocale (LocaleCategory.ALL, "");
	Intl.bindtextdomain (Config.GETTEXT_PACKAGE, Config.LOCALEDIR);
	Intl.textdomain (Config.GETTEXT_PACKAGE);

	var list = mce_ini_parse ();

	var dialog = new LedPatternDialog (list, osso);
	dialog.set_transient_for (window);

	int response = dialog.run ();
	dialog.destroy ();
	string command = null;
	if (response == Gtk.ResponseType.OK) {
		mce_ini_store (list);
		Hildon.Banner.show_information (window, null, _("Applying changes and restarting MCE ..."));
		command = "sudo /usr/bin/led-pattern-helper save %s".printf ("/tmp/mce.ini");
	} else if (response == LedPatternDialog.Response.RESTORE) {
		Hildon.Banner.show_information (window, null, _("Restoring defaults and restarting MCE ..."));
		command = "sudo /usr/bin/led-pattern-helper save %s".printf ("/etc/mce/mce.ini.orig");
	}
	if (command != null) {
		try {
			int exit_status;
			string error;
			Process.spawn_command_line_sync (command, null, out error, out exit_status);
			if (exit_status != 0) {
				var information = "Exit status: %d\n%s".printf (exit_status, error);
				var note = new Hildon.Note.information (window, information);
				note.run ();
			}
		} catch (SpawnError e) {
			Hildon.Banner.show_information (null, null, e.message);
		}
	}

	return Osso.Status.OK;
}

public static Osso.Status save_state (Osso.Context osso, void* data) {
	return Osso.Status.OK;
}
