#!/usr/bin/python2.5
import sys
from PyQt4 import QtGui, QtCore
from PyQt4.phonon import Phonon
from laser import *

class MyForm(QtGui.QMainWindow):
        def __init__(self, parent=None):
                #build parent user interface
                QtGui.QWidget.__init__(self, parent)
		self.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
		self.connect(QtGui.QApplication.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged)
                self.ui = Ui_MainWindow()
                self.ui.setupUi(self)
                self.ui.soundList.setCurrentRow(0)
                self.m_media = Phonon.MediaObject(self)
                audioOutput = Phonon.AudioOutput(Phonon.MusicCategory, self)
                audioOutput.setVolume(0.3)
                Phonon.createPath(self.m_media, audioOutput)
                #connect buttons
                QtCore.QObject.connect(self.ui.pushButton, QtCore.SIGNAL('clicked()'), self.playFart)
                
                self.sounds={
                        "Bilen":"/opt/Laserturken/bilen.wav", "Efternamn":"/opt/Laserturken/efternamn.wav",
                        "Garanti":"/opt/Laserturken/garanti.wav", "Kaos":"/opt/Laserturken/kaos.wav",
                        "Klippa":"/opt/Laserturken/klippa.wav", "Polisen":"/opt/Laserturken/polisen.wav", 
                        "Ta Han":"/opt/Laserturken/tahan.wav", "Tuta":"/opt/Laserturken/tuta.wav"
                        }
                
        def playFart(self):
                sound = self.sounds[str(self.ui.soundList.currentItem().text())]
                self.m_media.setCurrentSource(Phonon.MediaSource(sound))
                self.m_media.play()

	def orientationChanged(self):
		""" Re-order the widgets when the screen orientation changes """
		
		screenGeometry = QtGui.QApplication.desktop().screenGeometry()
		if screenGeometry.height() > screenGeometry.width():
			self.resize(480, 720)
			self.ui.frame.resize(460, 700)
			self.ui.soundList.resize(440, 360)
			self.ui.pushButton.setGeometry(QtCore.QRect(120, 420, 220, 220)) 
		else:
			self.resize(800, 400)
			self.ui.frame.resize(780, 380)
			self.ui.soundList.resize(300, 360)
			self.ui.pushButton.setGeometry(QtCore.QRect(440, 80, 220, 220))
                        

if __name__ == "__main__":
        app = QtGui.QApplication(sys.argv)
	app.setApplicationName("Simpsons Sounds")
        myapp = MyForm()
        myapp.show()
        sys.exit(app.exec_())
