#include <QGridLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QString>
#include <QDebug>
#include <QStyle>
#include <QFont>
#include <QIcon>
#include "vkb.h"

static unsigned short keys[3][10]={
    { 0x0686, 0x06cb, 0x06d0, 0x0631, 0x062a, 0x064a, 0x06c7, 0x06ad, 0x0648, 0x067e },  //ch, w, e, r, t, y, u, ng, o, p
    { 0x06be, 0x0633, 0x062f, 0x0627, 0x06d5, 0x0649, 0x0642, 0x0643, 0x0644, 0x061B },  //h,  s, d, a, e, i, q, k,  l, ؛
    { 0x0632, 0x0634, 0x063a, 0x06c8, 0x0628, 0x0646, 0x0645, 0x060C, 0x002E, 0x0626 }   //z, sh, gh,ü, b, n, m, ،,  ., hemze
};

static unsigned short skeys[3][10]={
    { 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039 },  //0, 1, 2, 3, 4, 5, 6, 7, 8, 9
    { 0x00BB, 0x00AB, 0x0698, 0x0641, 0x06af, 0x062e, 0x062c, 0x06c6, 0x002B, 0x003A },  //», «, dr, f, g, x, j, ö, +, :
    { 0x0021, 0x066A, 0x066D, 0x002f, 0x002d, 0x2014, 0x003D, 0x203a, 0x2039, 0x061F }   //!, %, *, /, -, —, =, ›, ‹, ؟
};

static int BUTTON_MAXIMUM_HEIGHT = 50;

VKB::VKB(QWidget *parent) :
    QWidget(parent),
    mShift(false)
{
    mUGFont = new QFont("UyghurEdit Riwaj");
    QVBoxLayout *layout = new QVBoxLayout;
    mvkb = createVKB(keys);
    layout->addWidget(mvkb);
    msvkb = createVKB(skeys);
    layout->addWidget(msvkb);
    msvkb->hide();
    createToolBar();
    layout->addWidget(mtbar);
    layout->setSpacing(0);
    setLayout(layout);
}

VKB::~VKB()
{
    delete mUGFont;
}

void VKB::keyClicked()
{
    QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());
    emit VKBButtonClicked(clickedButton->text());
}

void VKB::shiftButtonClicked()
{
    if (mShiftToggled) {
        msvkb->hide();
        mvkb->show();
        mShift->setText("");
        mShiftToggled=false;
    } else {
        mvkb->hide();
        msvkb->show();
        mShift->setText("*");
        mShiftToggled=true;
    }
}

void VKB::spaceButtonClicked()
{
    emit VKBButtonClicked(QString(" "));
}

void VKB::enterButtonClicked()
{
    emit VKBButtonClicked(QString("\n"));
}

QWidget* VKB::createVKB(const unsigned short  keys[3][10])
{
    QWidget *vkb = new QWidget();
    QGridLayout *layout = new QGridLayout;
    for (int i=0; i<3; i++) {
        for (int j=0; j<10; j++) {
            QPushButton *key = new QPushButton(QString(keys[i][j]));
            qDebug()<<key->fontInfo().family();
            key->setFont(*mUGFont);
            key->setMaximumHeight(BUTTON_MAXIMUM_HEIGHT);
            qDebug()<<key->fontInfo().family();
            connect(key, SIGNAL(clicked()), this, SLOT(keyClicked()));
            layout->addWidget(key, i, j);
        }
    }
    layout->setSpacing(0);
    vkb->setLayout(layout);
    return vkb;
}

/**
 * toolbar always visible and it contains following buttons
 * Open: open a file
 * Save: save Text to a file
 * Copy: copy the content to clipboard
 * Shift: controls to switch between two VKB
 * forward: move the cursor to the forward
 * Space: input blank space
 * backward: move the cursor to the backward
 * Enter: input line break
 * Backspace: delete the character before the cursor
 */
void VKB::createToolBar()
{
    mtbar = new QWidget();
    QHBoxLayout *layout = new QHBoxLayout;
    mOpen = new QPushButton(QIcon(":/images/open.png"), QString());
    connect(mOpen, SIGNAL(clicked()), this, SIGNAL(openButtonClicked()));
    layout->addWidget(mOpen);

    mSave = new QPushButton(QIcon(":/images/save.png"), QString());
    connect(mSave, SIGNAL(clicked()), this, SIGNAL(saveButtonClicked()));
    layout->addWidget(mSave);

    mCopy = new QPushButton(QIcon(":/images/copy.png"), QString());
    connect(mCopy, SIGNAL(clicked()), this, SIGNAL(copyButtonClicked()));
    layout->addWidget(mCopy);

    mPaste = new QPushButton(QIcon(":/images/paste.png"), QString());
    connect(mPaste, SIGNAL(clicked()), this, SIGNAL(pasteButtonClicked()));
    layout->addWidget(mPaste);

    mShift = new QPushButton(QIcon(":/images/shift.png"), QString());
    connect(mShift, SIGNAL(clicked()), this, SLOT(shiftButtonClicked()));
    layout->addWidget(mShift);

    mFW = new QPushButton(style()->standardIcon(QStyle::SP_ArrowLeft), QString());
    connect(mFW, SIGNAL(clicked()), this, SIGNAL(fwButtonClicked()));
    layout->addWidget(mFW);

    mSpace = new QPushButton(QIcon(":/images/space.png"), QString());
    connect(mSpace, SIGNAL(clicked()), this, SLOT(spaceButtonClicked()));
    layout->addWidget(mSpace);

    mBW = new QPushButton(style()->standardIcon(QStyle::SP_ArrowRight), QString());
    connect(mBW, SIGNAL(clicked()), this, SIGNAL(bwButtonClicked()));
    layout->addWidget(mBW);

    mEnter = new QPushButton(QIcon(":/images/enter.png"), QString());
    connect(mEnter, SIGNAL(clicked()), this, SLOT(enterButtonClicked()));
    layout->addWidget(mEnter);

    mBSpace = new QPushButton(QIcon(":/images/bkspc.png"), QString());
    connect(mBSpace, SIGNAL(clicked()), this, SIGNAL(bspaceButtonClicked()));
    layout->addWidget(mBSpace);
    layout->setSpacing(0);
    mtbar->setLayout(layout);
}
