#include <QVBoxLayout>
#include <QTextEdit>
#include <QTextCursor>
#include <QTextCharFormat>
#include <QFileDialog>
#include <QTextStream>
#include <QClipboard>
#include <QDebug>
#include <QApplication>

#include "kumushedit.h"

KumushEdit::KumushEdit(QWidget *parent) :
    QWidget(parent)
{
    QVBoxLayout *layout = new QVBoxLayout;
    createTextEdit();
    layout->addWidget(mTextEdit);
    createVKB();
    layout->addWidget(mVKB);
    layout->setSizeConstraint(QLayout::SetMaximumSize);
    layout->setSpacing(0);
    this->setLayout(layout);
    connect(mVKB, SIGNAL(VKBButtonClicked(QString)), this, SLOT(VKBButtonClicked(QString)));
    connect(mVKB, SIGNAL(openButtonClicked()), this, SLOT(openButtonClicked()));
    connect(mVKB, SIGNAL(saveButtonClicked()), this, SLOT(saveButtonClicked()));
    connect(mVKB, SIGNAL(copyButtonClicked()), this, SLOT(copyButtonClicked()));
    connect(mVKB, SIGNAL(pasteButtonClicked()), this, SLOT(pasteButtonClicked()));
    connect(mVKB, SIGNAL(fwButtonClicked()), this, SLOT(fwButtonClicked()));
    connect(mVKB, SIGNAL(bwButtonClicked()), this, SLOT(bwButtonClicked()));
    connect(mVKB, SIGNAL(bspaceButtonClicked()), this, SLOT(bspaceButtonClicked()));
}

KumushEdit::~KumushEdit()
{
}

void KumushEdit::createTextEdit()
{
    mTextEdit = new QTextEdit;
}

void KumushEdit::createVKB()
{
    mVKB = new VKB;
}

void KumushEdit::VKBButtonClicked(QString value)
{
    QTextCursor cursor = mTextEdit->textCursor();
    QTextCharFormat textFormat = cursor.charFormat();
    textFormat.setFontFamily("UyghurEdit Riwaj");
    cursor.insertText(value, textFormat);
    mTextEdit->setFocus();
    mTextEdit->ensureCursorVisible();
}

void KumushEdit::openButtonClicked()
{
    fileName = QFileDialog::getOpenFileName(this, "Hojjetni Tallang", NULL, "Tekist Hojjetliri (*.txt)");
    QFile file(fileName, this);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;
    mTextEdit->clear();
    QTextCursor cursor = mTextEdit->textCursor();
    QTextCharFormat textFormat = cursor.charFormat();
    textFormat.setFontFamily("UyghurEdit Riwaj");
    QTextStream in(&file);
    while (!in.atEnd()) {
        QString line = in.readLine() + "\n";
        cursor.insertText(line, textFormat);
    }
    file.close();
    mTextEdit->setFocus();
}

void KumushEdit::saveButtonClicked()
{
    fileName = QFileDialog::getSaveFileName(this, "Hojjetni Saqlang", fileName, "Tekist Hojjetliri (*.txt)");
    QFile file(fileName, this);
    if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
        return;
    QTextStream out(&file);
    qDebug()<<mTextEdit->toPlainText();
    out<<mTextEdit->toPlainText();
    file.close();
    mTextEdit->setFocus();
}

void KumushEdit::copyButtonClicked()
{
    QClipboard *clipboard = QApplication::clipboard();
    qDebug()<<mTextEdit->toPlainText();
    clipboard->setText(mTextEdit->toPlainText());
    qDebug()<<clipboard->text();
    mTextEdit->setFocus();
}

void KumushEdit::pasteButtonClicked()
{
    QClipboard *clipboard = QApplication::clipboard();
    QString text = clipboard->text();
    QTextCursor cursor = mTextEdit->textCursor();
    QTextCharFormat textFormat = cursor.charFormat();
    textFormat.setFontFamily("UyghurEdit Riwaj");
    cursor.insertText(text, textFormat);
    mTextEdit->setFocus();
    mTextEdit->ensureCursorVisible();
}

void KumushEdit::fwButtonClicked()
{
    QTextCursor cursor = mTextEdit->textCursor();
    cursor.setPosition(cursor.position()+1);
    mTextEdit->setTextCursor(cursor);
    mTextEdit->setFocus();
    mTextEdit->ensureCursorVisible();
}

void KumushEdit::bwButtonClicked()
{
    QTextCursor cursor = mTextEdit->textCursor();
    cursor.setPosition(cursor.position()-1);
    mTextEdit->setTextCursor(cursor);
    mTextEdit->setFocus();
    mTextEdit->ensureCursorVisible();
}

void KumushEdit::bspaceButtonClicked()
{
    mTextEdit->textCursor().deletePreviousChar();
    mTextEdit->setFocus();
    mTextEdit->ensureCursorVisible();
}
