#!/usr/bin/env python
# coding=utf-8
import gtk
import hildon
import random
import gzip
import os
import gobject
import re
import ConfigParser

class Kanji:
    kanji=''
    on=''
    kun=''
    translation=''
    picture=''
    compound_list=[]
    
    def __init__(self):
        kanji=''
        on=''
        kun=''
        translation=''
        picture=''
        compound_list=[]

class KanjiTeacher:
    kanji_list=[]
    current_kanji=0
    current_dataset='0-100'
    current_compound=0
    kanji_count=0

    label_number=gtk.Label()
    label_kanji=gtk.Label()
    label_on=gtk.Label()
    label_kun=gtk.Label()
    label_translation=gtk.Label()
    label_compound=gtk.Label()
    label_pos=gtk.Label()
    image=gtk.Image()

    main_dir='/opt/ktmobile'
    kt_mobile_cfg=os.path.expanduser('~/.kt_mobilerc')

    Config = ConfigParser.ConfigParser()

    if os.path.isfile(kt_mobile_cfg) == False:
        ini_file = open(kt_mobile_cfg,'w') # create if not there yet
        Config.add_section('Dataset') # add section to config
        Config.set('Dataset','initial_load','1-100') # start with lowest set
        Config.write(ini_file)
        ini_file.close()
    Config.read(kt_mobile_cfg)
    initial_dataset=Config.get('Dataset','initial_load')




    def gesture(self, widget, direction, startx, starty):
        print 'widget:%s direction:%s startx:%s starty:%s'%(widget,direction,startx,starty)
        if direction==3:
            self.next_kanji(self.win)
            print 'RIGHT!!'
        if direction==2:
            self.previous_kanji(self.win)
            print 'RIGHT!!'


    def panning_finished(self,widget):
        print 'panning finished!!!!!!!!'
    

    def dataset_choice(self,widget):
        self.kanji_list=[]
        self.current_kanji=0
        self.current_compound=0
        self.kanji_count=0
        print '%s/kanji_files/parts/%s.xml'%(self.main_dir,self.button_db.get_value())
        self.read_from_database('%s/kanji_files/parts/%s.xml'%(self.main_dir,self.button_db.get_value()))
        self.current_dataset=self.button_db.get_value()[:self.button_db.get_value().find('-')]
        self.Config.set('Dataset','initial_load',self.button_db.get_value())
        ini_file=open(self.kt_mobile_cfg,'w')
        self.Config.write(ini_file)
        ini_file.close()
        print 'setting config to %s'%self.button_db.get_value()
        return 0

    def create_db_selector(self):
        self.db_selector = hildon.TouchSelector()
        db_list=[]
        path='%s/kanji_files/parts/'%self.main_dir
        for filename in os.listdir(path):
            if re.search('^[0-9]',filename):
                db_list.append(filename.replace('.xml',''))
        try:
            #self.read_from_database('/home/user/kt_mobile/data_files/kanjidic2b.xml')
            #print self.initial_dataset
            self.current_dataset=self.initial_dataset[:self.initial_dataset.find('-')]
            print 'loading: %s/kanji_files/parts/%s.xml'%(self.main_dir,self.initial_dataset)
            self.read_from_database('%s/kanji_files/parts/%s.xml'%(self.main_dir,self.initial_dataset))
            db_list.sort(lambda x,y: cmp(int(x[:x.find('-')]),int(y[:y.find('-')]))) # sorting so that 0-100,100-200... and not 0-100,1000-1100...200
        except:
            print 'could not find any files'
            pass

        renderer = gtk.CellRendererText()

        store_db=gtk.ListStore(gobject.TYPE_STRING)
        for item in db_list:
            new_iter=store_db.append()
            store_db.set_value(new_iter,0,item)
        #print len(db_list)

        self.db_column = self.db_selector.append_column(store_db,renderer)
        self.db_column.pack_start(renderer,0)
        self.db_column.set_attributes(renderer,text=0)
        self.db_selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        self.db_column.set_property('text-column',0)


    
    def __init__(self):
        self.program = hildon.Program.get_instance()
        self.window = hildon.StackableWindow()   # creating window
        self.program.add_window(self.window)
        
        self.window.set_title("Kanji-Teacher Mobile")     # setting title
        self.window.connect("delete_event",gtk.main_quit,None)
        self.window.connect("destroy",gtk.main_quit,None)

        self.selector = hildon.TouchSelector()
        self.selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        
        self.menu=hildon.AppMenu()
   
        ds=self.create_db_selector()
        self.button_db=hildon.PickerButton(gtk.HILDON_SIZE_AUTO,hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button_db.set_title('Dataset')
        self.menu.append(self.button_db)
        self.button_db.set_selector(self.db_selector)
        self.button_db.connect("value-changed",self.dataset_choice) 
        
        
        self.pannable_area=hildon.PannableArea()
        self.table=self.create_table()
        self.pannable_area.add_with_viewport(self.table)
        self.pannable_area.show_all()
        self.window.add(self.pannable_area)
        
        self.kanji_number = 0
        self.kanji = ''
        self.on = '' 
        self.kun = '' 
        self.translation = '' 
        self.compound = '' 
        self.picture = '' 
        self.display_kanjis()
   
        self.button_about=hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.button_about.set_label('About')
        self.button_about.connect('clicked',self.about)
        self.menu.append(self.button_about)
    
    
    
        self.menu.show_all()
        self.window.set_app_menu(self.menu)
        self.window.show_all()
        self.display_kanjis()
    
    
    
    
    def __del__(self):
        try:
            self.personal_db.close()
        except:
            pass



    def display_kanjis(self):
        self.label_number.set_text(str(self.current_kanji-1+int(self.current_dataset)))
        self.label_kanji.set_text(self.kanji_list[self.current_kanji].kanji)
        self.label_on.set_text(self.kanji_list[self.current_kanji].on)
        self.label_kun.set_text(self.kanji_list[self.current_kanji].kun)
        self.label_translation.set_text(self.kanji_list[self.current_kanji].translation)

        
        
    def read_from_database(self,kanjis):
        #fh = gzip.open(kanjis,'r')
        fh = open(kanjis,'r')
        k=Kanji()
        for line in fh:
           line = line.replace('\n','')
           if line.find('<character>')!=-1:
               self.kanji_count+=1
               k = Kanji()
           if line.find('<literal>')!=-1:
               temp=line[line.find('>')+1:line.find('</')]
               k.kanji=temp
               k.picture=temp
               #print temp
           
           if line.find('ja_on')!=-1:
               temp=line[line.find('>')+1:line.find('</')]
               k.on+='%s '%(temp)
               #print k.on

           
           if line.find('ja_kun')!=-1:
               temp=line[line.find('>')+1:line.find('</')]
               k.kun+='%s '%(temp)
               #print k.kun
           
           if line.find('<meaning>')!=-1:
               temp=line[line.find('>')+1:line.find('</')]
               k.translation+='%s, '%(temp)
               #print k.translation
           
           if line.find('</character>')!=-1:
               self.kanji_list.append(k)
        fh.close()
    
    
    def read_compounds(self,compounds):
        k = self.kanji_list[self.current_kanji]
        if len(k.compound_list) < 1: 
            k.compound_list=[]
            fh = open('%s%s'%(self.main_dir,'/edict/compounds'),'r')
            for line in fh:
                if line.find(k.kanji)!=-1:
                    k.compound_list.append(line)
            fh.close()

    def show_license(self,widget):
        os.system('browser --url http://kanjicafe.com/license.htm')
        return 0



    def show_writing(self,widget):
        win = hildon.StackableWindow()
        win.set_title("Kanji-Teacher Mobile - Writing")
        align = gtk.Alignment(0.5,0.5,0,0)
        vbox = gtk.VBox()
        try:
            pixbuf = gtk.gdk.pixbuf_new_from_file('%s%s%s.png'%(self.main_dir,'/sod/',self.kanji_list[self.current_kanji].kanji))
            pixbuf = pixbuf.scale_simple(pixbuf.get_width()*1.5,pixbuf.get_height()*1.5,gtk.gdk.INTERP_BILINEAR)
            image = gtk.image_new_from_pixbuf(pixbuf) 
            vbox.pack_start(image,False,False,0)
            label = gtk.Label('Stroke order Diagram licensed from www.kanjicafe.com')
            button = gtk.Button('License Page')
            button.connect('clicked',self.show_license)
            vbox.pack_end(button,False,False,0)
        except:
            label = gtk.Label('Sorry, Stroke Diagram not yet available for this kanji')
        vbox.pack_start(label,False,False,0)
        align.add(vbox)
        win.add(align)
        win.show_all()

    def save_compound(self,selector,user_data):
        note = hildon.hildon_note_new_confirmation(self.window,"Do you want to add this compound to your personal database?")
        response = gtk.Dialog.run(note)
        gtk.Dialog.destroy(note) # important, w/o this line the confirmation dialog gets stuck
        if response==gtk.RESPONSE_OK:
            try:
                personal_db = open('/home/user/MyDocs/.documents/kanji.db','a')
                personal_db.write(selector.get_current_text())
                info = hildon.hildon_note_new_information(self.window,"Compound added to personal database!")
                personal_db.close()
            except:
                info = hildon.hildon_note_new_information(self.window,"Could not open personal database!")
                pass
            print 'writing %s to personal db'%selector.get_current_text()
            gtk.Dialog.run(info)
        if response==gtk.RESPONSE_CANCEL:
            pass



    def show_compounds(self,widget):
        win = hildon.StackableWindow()
        win.set_title("Kanji-Teacher Mobile - Compounds")
        
        selector = hildon.TouchSelector()
        compound_list=[]

        self.read_compounds('/home/user/kt_mobile/data_files/compounds')
        for item in self.kanji_list[self.current_kanji].compound_list:
            compound_list.append(item)
        
        store_compounds=gtk.ListStore(gobject.TYPE_STRING)
        for compound in compound_list:
            new_iter=store_compounds.append()
            store_compounds.set_value(new_iter,0,compound)

        renderer=gtk.CellRendererText()
        compound_column=selector.append_column(store_compounds,renderer)
        compound_column.pack_start(renderer,1)
        compound_column.set_attributes(renderer,text=0)
        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        selector.connect('changed',self.save_compound)
        compound_column.set_property('text-column',0)
        win.add(selector)
        win.show_all()

    def previous_kanji(self,widget):
        print self.current_kanji
        if self.current_kanji==0:
            self.current_kanji=len(self.kanji_list)-1
        else:
            self.current_kanji-=1
        self.display_kanjis()
        print self.current_kanji
        print
        print
    
    
    def next_kanji(self,widget):
        print self.current_kanji
        if self.current_kanji == len(self.kanji_list)-1:
            self.current_kanji=0
        else:
            self.current_kanji+=1
        self.display_kanjis()
        print self.current_kanji
        print
        print


    def random_kanji(self,widget):
        random.seed(None)
        self.current_kanji = random.randrange(1,len(self.kanji_list)-1)
        self.display_kanjis()


    def random_compound(self,widget):
        win = hildon.StackableWindow()
        win.set_title("Kanji-Teacher Mobile - Compounds")
        label = gtk.Label("Here are the compounds")
        vbox = gtk.VBox(False,0)
        vbox.pack_start(label,True,True,0)
        win.add(vbox)
        win.show_all()

    def open_personal_database(self,widget):
        win = hildon.StackableWindow()
        win.set_title("Kanji-Teacher Mobile - My Database")
        comps=''
        pannable_area=hildon.PannableArea()
        pannable_area.set_property("mov-mode",hildon.MOVEMENT_MODE_BOTH)
        vbox = gtk.VButtonBox()
        counter=0
        personal_db = open('/home/user/MyDocs/.documents/kanji.db','r')
        for item in personal_db:
            label = gtk.Label(item)
            label.set_line_wrap(True)
            vbox.pack_start(label,False,False,0)
            counter+=1
        pannable_area.add_with_viewport(vbox)
        win.add(pannable_area)
        win.show_all()
        
        
        
    
    
    def create_table(self):
        table = gtk.Table(3,9,False)
        table.set_row_spacings(10)
        table.set_col_spacings(10)
        table.show()
        
        label=gtk.Label('kanji#')
        label.set_size_request(390,-1)
        table.attach(label,0,1,0,1)
        self.label_number=gtk.Label('')
        self.label_number.set_line_wrap(True)
        self.label_number.set_size_request(390,-1)
        table.attach(self.label_number,1,2,0,1)
        
        label=gtk.Label('kanji:')
        label.set_size_request(390,-1)
        table.attach(label,0,1,1,2)
        self.label_kanji.set_text('')
        self.label_kanji.set_line_wrap(True)
        self.label_kanji.set_size_request(390,-1)
        table.attach(self.label_kanji,1,2,1,2)
        
        label=gtk.Label('on reading:')
        label.set_size_request(390,-1)
        table.attach(label,0,1,2,3)
        self.label_on.set_text('')
        self.label_on.set_line_wrap(True)
        self.label_on.set_size_request(390,-1)
        table.attach(self.label_on,1,2,2,3)
        
        label=gtk.Label('kun reading:')
        label.set_size_request(390,-1)
        table.attach(label,0,1,3,4)
        self.label_kun.set_text('')
        self.label_kun.set_line_wrap(True)
        self.label_kun.set_size_request(390,-1)
        table.attach(self.label_kun,1,2,3,4)
        
        label=gtk.Label('translation:')
        label.set_size_request(390,-1)
        table.attach(label,0,1,4,5)
        self.label_translation.set_text('')
        self.label_translation.set_line_wrap(True)
        self.label_translation.set_size_request(390,-1)
        table.attach(self.label_translation,1,2,4,5)
       
        button_previous=gtk.Button('previous kanji')
        button_previous.connect("clicked",self.previous_kanji)
        button_previous.set_size_request(390,-1)
        table.attach(button_previous,0,1,6,7)
        
        button_next=gtk.Button('next kanji')
        button_next.connect("clicked",self.next_kanji)
        button_next.set_size_request(390,-1)
        table.attach(button_next,1,2,6,7)
        
        button_random=gtk.Button('random kanji')
        button_random.connect("clicked",self.random_kanji)
        button_random.set_size_request(390,-1)
        table.attach(button_random,0,1,7,8)
        
        button_compound=gtk.Button('compounds')
        button_compound.connect("clicked",self.show_compounds)
        button_compound.set_size_request(390,-1)
        table.attach(button_compound,1,2,7,8)

        button_writing=gtk.Button('writing')
        button_writing.connect("clicked",self.show_writing)
        button_writing.set_size_request(390,-1)
        table.attach(button_writing,0,1,8,9)

        button_database=gtk.Button('my database')
        button_database.connect("clicked",self.open_personal_database)
        button_database.set_size_request(390,-1)
        table.attach(button_database,1,2,8,9)
        return table

    def get_rotation(self):
        try:
            f = open ("/sys/class/i2c-adapter/i2c-3/3-001d/coord",'r')
            coords = [int(w) for w in f.readline().split()]
            f.close()
        except:
            coords = 'no accelerometer'
        return coords



    def about(self,widget):
        about=gtk.AboutDialog()
        about.set_program_name('Kanji Teacher Mobile')
        about.set_version('0.5')
        about.set_copyright('(C) Bartholomaeus Wloka')
        about.set_comments('A language learning environment for Japanese characters')
        about.set_website('http://wloka.dac.univie.ac.at')
        about.run()
        about.destroy()







def main():
    gtk.main()
    return 0

if __name__=="__main__":
    KanjiTeacher()
    main()
