#ifndef EDITWIDGET_H
#define EDITWIDGET_H

#include <QWidget>
#include <QtGui>
#include <QColor>
#include "history.h"

class EditWidget : public QLabel
{
	Q_OBJECT
	
public:	
	EditWidget(QWidget *parent);
	~EditWidget();
	void editChangeSizeBrush(int size);
	void editChooseColor(QColor color);
	void drawRectSelect();
	void removeSelect();
    void drawCropSelect();
	void drawPenSelect();
    void drawResize();
    void deleteObject(QPaintDevice *obj);
	void saveToHistory();
	void setImage(QString fname);
	void rotate(int angle);
	void make_grayscale(QImage& in);

	QPixmap *pixmap;
    QPixmap *saveSelectPix;
	QPointF prevPoint;
    QPointF curPoint;
	bool checkPen;
	bool selectRect;
    
private:
	QPen *pen;
    QPen *penSelect;
	History *pixmapHistory;

public slots:
	void mouseReleaseEvent(QMouseEvent* pEvent);
	void mouseMoveEvent(QMouseEvent* pEvent);
	void mousePressEvent(QMouseEvent* pEvent);
	void paintEvent(QPaintEvent *event);
	void undo();
	void redo();
	void rotateLeft();
	void rotateRight();
	void makeGrayScale();
	void makeBlackAndWhite();
};

#endif // EDITWIDGET_H
