#include <kdialog.h>
#include <klocale.h>

#ifndef UI_IMPORTDIALOGUI_H
#define UI_IMPORTDIALOGUI_H

#include <qvariant.h>


#include <Qt3Support/Q3ButtonGroup>
#include <Qt3Support/Q3GroupBox>
#include <Qt3Support/Q3MimeSourceFactory>
#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QButtonGroup>
#include <QtGui/QCheckBox>
#include <QtGui/QComboBox>
#include <QtGui/QGridLayout>
#include <QtGui/QHeaderView>
#include <QtGui/QRadioButton>
#include <QtGui/QSpacerItem>
#include <QtGui/QVBoxLayout>
#include <QtGui/QWidget>

QT_BEGIN_NAMESPACE

class Ui_ImportDialogUI
{
public:
    QVBoxLayout *vboxLayout;
    Q3ButtonGroup *buttonGroupEncoding;
    QGridLayout *gridLayout;
    QComboBox *comboBoxEncoding;
    QRadioButton *radioEncodingOther;
    QSpacerItem *Spacer5;
    QRadioButton *radioEncodingDefault;
    QSpacerItem *Spacer4;
    Q3GroupBox *groupAdvanced;
    QGridLayout *gridLayout1;
    QCheckBox *checkBoxLinespacing;
    QSpacerItem *Spacer3;
    QCheckBox *checkBoxImageOffset;
    QSpacerItem *Spacer5_2;
    QSpacerItem *Spacer6;

    void setupUi(QWidget *ImportDialogUI)
    {
        if (ImportDialogUI->objectName().isEmpty())
            ImportDialogUI->setObjectName(QString::fromUtf8("ImportDialogUI"));
        ImportDialogUI->resize(343, 221);
        vboxLayout = new QVBoxLayout(ImportDialogUI);
        vboxLayout->setSpacing(6);
        vboxLayout->setMargin(11);
        vboxLayout->setObjectName(QString::fromUtf8("vboxLayout"));
        buttonGroupEncoding = new Q3ButtonGroup(ImportDialogUI);
        buttonGroupEncoding->setObjectName(QString::fromUtf8("buttonGroupEncoding"));
        QSizePolicy sizePolicy(static_cast<QSizePolicy::Policy>(3), static_cast<QSizePolicy::Policy>(5));
        sizePolicy.setHorizontalStretch(0);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(buttonGroupEncoding->sizePolicy().hasHeightForWidth());
        buttonGroupEncoding->setSizePolicy(sizePolicy);
        buttonGroupEncoding->setColumnLayout(0, Qt::Vertical);
        buttonGroupEncoding->layout()->setSpacing(6);
        buttonGroupEncoding->layout()->setMargin(11);
        gridLayout = new QGridLayout();
        QBoxLayout *boxlayout = qobject_cast<QBoxLayout *>(buttonGroupEncoding->layout());
        if (boxlayout)
            boxlayout->addLayout(gridLayout);
        gridLayout->setAlignment(Qt::AlignTop);
        gridLayout->setObjectName(QString::fromUtf8("gridLayout"));
        comboBoxEncoding = new QComboBox(buttonGroupEncoding);
        comboBoxEncoding->setObjectName(QString::fromUtf8("comboBoxEncoding"));
        QSizePolicy sizePolicy1(static_cast<QSizePolicy::Policy>(1), static_cast<QSizePolicy::Policy>(5));
        sizePolicy1.setHorizontalStretch(0);
        sizePolicy1.setVerticalStretch(0);
        sizePolicy1.setHeightForWidth(comboBoxEncoding->sizePolicy().hasHeightForWidth());
        comboBoxEncoding->setSizePolicy(sizePolicy1);

        gridLayout->addWidget(comboBoxEncoding, 1, 1, 1, 2);

        radioEncodingOther = new QRadioButton(buttonGroupEncoding);
        radioEncodingOther->setObjectName(QString::fromUtf8("radioEncodingOther"));
        radioEncodingOther->setChecked(false);
        buttonGroupEncoding->insert(radioEncodingOther, 1);

        gridLayout->addWidget(radioEncodingOther, 1, 0, 1, 1);

        Spacer5 = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        gridLayout->addItem(Spacer5, 1, 3, 1, 1);

        radioEncodingDefault = new QRadioButton(buttonGroupEncoding);
        radioEncodingDefault->setObjectName(QString::fromUtf8("radioEncodingDefault"));
        radioEncodingDefault->setChecked(true);
        buttonGroupEncoding->insert(radioEncodingDefault, 0);

        gridLayout->addWidget(radioEncodingDefault, 0, 0, 1, 2);

        Spacer4 = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        gridLayout->addItem(Spacer4, 0, 2, 1, 2);


        vboxLayout->addWidget(buttonGroupEncoding);

        groupAdvanced = new Q3GroupBox(ImportDialogUI);
        groupAdvanced->setObjectName(QString::fromUtf8("groupAdvanced"));
        groupAdvanced->setColumnLayout(0, Qt::Vertical);
        groupAdvanced->layout()->setSpacing(6);
        groupAdvanced->layout()->setMargin(11);
        gridLayout1 = new QGridLayout();
        QBoxLayout *boxlayout1 = qobject_cast<QBoxLayout *>(groupAdvanced->layout());
        if (boxlayout1)
            boxlayout1->addLayout(gridLayout1);
        gridLayout1->setAlignment(Qt::AlignTop);
        gridLayout1->setObjectName(QString::fromUtf8("gridLayout1"));
        checkBoxLinespacing = new QCheckBox(groupAdvanced);
        checkBoxLinespacing->setObjectName(QString::fromUtf8("checkBoxLinespacing"));
        QSizePolicy sizePolicy2(static_cast<QSizePolicy::Policy>(1), static_cast<QSizePolicy::Policy>(0));
        sizePolicy2.setHorizontalStretch(0);
        sizePolicy2.setVerticalStretch(0);
        sizePolicy2.setHeightForWidth(checkBoxLinespacing->sizePolicy().hasHeightForWidth());
        checkBoxLinespacing->setSizePolicy(sizePolicy2);

        gridLayout1->addWidget(checkBoxLinespacing, 0, 0, 1, 2);

        Spacer3 = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        gridLayout1->addItem(Spacer3, 0, 2, 1, 1);

        checkBoxImageOffset = new QCheckBox(groupAdvanced);
        checkBoxImageOffset->setObjectName(QString::fromUtf8("checkBoxImageOffset"));
        checkBoxImageOffset->setChecked(true);

        gridLayout1->addWidget(checkBoxImageOffset, 1, 0, 1, 1);

        Spacer5_2 = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        gridLayout1->addItem(Spacer5_2, 1, 1, 1, 2);


        vboxLayout->addWidget(groupAdvanced);

        Spacer6 = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        vboxLayout->addItem(Spacer6);

        QWidget::setTabOrder(radioEncodingDefault, comboBoxEncoding);
        QWidget::setTabOrder(comboBoxEncoding, checkBoxLinespacing);
        QWidget::setTabOrder(checkBoxLinespacing, checkBoxImageOffset);

        retranslateUi(ImportDialogUI);

        QMetaObject::connectSlotsByName(ImportDialogUI);
    } // setupUi

    void retranslateUi(QWidget *ImportDialogUI)
    {
        ImportDialogUI->setWindowTitle(tr2i18n("MS Write Import Dialog", 0));
        buttonGroupEncoding->setTitle(tr2i18n("&Encoding", 0));
#ifndef UI_QT_NO_WHATSTHIS
        buttonGroupEncoding->setProperty("whatsThis", QVariant(tr2i18n("Select the encoding of the Write document.<br><br>Try the Default  Encoding (CP 1252), if unsure.", 0)));
#endif // QT_NO_WHATSTHIS
        radioEncodingOther->setText(tr2i18n("&Other encoding:", 0));
        radioEncodingDefault->setText(tr2i18n("&Default encoding (CP 1252)", 0));
#ifndef UI_QT_NO_WHATSTHIS
        radioEncodingDefault->setProperty("whatsThis", QVariant(tr2i18n("Most Write documents are stored using this encoding (also known as windows-1252).<br><br>Select this if unsure.", 0)));
#endif // QT_NO_WHATSTHIS
        groupAdvanced->setTitle(tr2i18n("&Advanced", 0));
#ifndef UI_QT_NO_WHATSTHIS
        groupAdvanced->setProperty("whatsThis", QVariant(tr2i18n("These advanced options allow you to fine-tune the importing of formatting information. They compensate for differences between KWord and MS Write by adding extra formatting information (not found in the original document), to try to make the imported document look as close to the original as possible.<br><br>It is safe to use the defaults, if unsure.", 0)));
#endif // QT_NO_WHATSTHIS
        checkBoxLinespacing->setText(tr2i18n("Compensate for &linespacing differences", 0));
#ifndef UI_QT_NO_TOOLTIP
        checkBoxLinespacing->setProperty("toolTip", QVariant(QString()));
#endif // QT_NO_TOOLTIP
#ifndef UI_QT_NO_WHATSTHIS
        checkBoxLinespacing->setProperty("whatsThis", QVariant(tr2i18n("Try to simulate Write's linespacing by adding some spaces before each paragraph.", 0)));
#endif // QT_NO_WHATSTHIS
        checkBoxImageOffset->setText(tr2i18n("Enable &image positioning", 0));
#ifndef UI_QT_NO_WHATSTHIS
        checkBoxImageOffset->setProperty("whatsThis", QVariant(tr2i18n("Use paragraph indentation to position images.", 0)));
#endif // QT_NO_WHATSTHIS
        Q_UNUSED(ImportDialogUI);
    } // retranslateUi

};

namespace Ui {
    class ImportDialogUI: public Ui_ImportDialogUI {};
} // namespace Ui

QT_END_NAMESPACE

class ImportDialogUI : public QWidget, public Ui::ImportDialogUI
{
    Q_OBJECT

public:
    ImportDialogUI(QWidget* parent = 0, const char* name = 0, Qt::WindowFlags fl = 0);
    ~ImportDialogUI();

protected slots:
    virtual void languageChange();

};

#endif // IMPORTDIALOGUI_H

