// This file was automatically generated from records.xml
#ifndef SWINDER_RECORDS_H
#define SWINDER_RECORDS_H

#include "utils.h"

namespace Swinder {

void registerRecordClasses();

class BackupRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    BackupRecord();
    virtual ~BackupRecord();

    BackupRecord( const BackupRecord& record );
    BackupRecord& operator=( const BackupRecord& record );

    bool isBackupEnabled() const;
    void setBackupEnabled( bool backupEnabled );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Backup"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class EOFRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    EOFRecord();
    virtual ~EOFRecord();

    EOFRecord( const EOFRecord& record );
    EOFRecord& operator=( const EOFRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "EOF"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class BlankRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    BlankRecord();
    virtual ~BlankRecord();

    BlankRecord( const BlankRecord& record );
    BlankRecord& operator=( const BlankRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Blank"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class BoolErrRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    BoolErrRecord();
    virtual ~BoolErrRecord();

    BoolErrRecord( const BoolErrRecord& record );
    BoolErrRecord& operator=( const BoolErrRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    bool isError() const;
    void setError( bool error );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned value() const;
    void setValue( unsigned value );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    Value asValue() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "BoolErr"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class LeftMarginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    LeftMarginRecord();
    virtual ~LeftMarginRecord();

    LeftMarginRecord( const LeftMarginRecord& record );
    LeftMarginRecord& operator=( const LeftMarginRecord& record );

    double leftMargin() const;
    void setLeftMargin( double leftMargin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "LeftMargin"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class RightMarginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    RightMarginRecord();
    virtual ~RightMarginRecord();

    RightMarginRecord( const RightMarginRecord& record );
    RightMarginRecord& operator=( const RightMarginRecord& record );

    double rightMargin() const;
    void setRightMargin( double rightMargin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "RightMargin"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class TopMarginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    TopMarginRecord();
    virtual ~TopMarginRecord();

    TopMarginRecord( const TopMarginRecord& record );
    TopMarginRecord& operator=( const TopMarginRecord& record );

    double topMargin() const;
    void setTopMargin( double topMargin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "TopMargin"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class BottomMarginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    BottomMarginRecord();
    virtual ~BottomMarginRecord();

    BottomMarginRecord( const BottomMarginRecord& record );
    BottomMarginRecord& operator=( const BottomMarginRecord& record );

    double bottomMargin() const;
    void setBottomMargin( double bottomMargin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "BottomMargin"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class BoundSheetRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    BoundSheetRecord();
    virtual ~BoundSheetRecord();

    BoundSheetRecord( const BoundSheetRecord& record );
    BoundSheetRecord& operator=( const BoundSheetRecord& record );

    enum SheetState {
        Visible = 0,
        Hidden = 1,
        StrongHidden = 2
    };

    static UString sheetStateToString(SheetState sheetState);

    enum SheetType {
        Worksheet = 0x00,
        Chart = 0x02,
        VBModule = 0x06
    };

    static UString sheetTypeToString(SheetType sheetType);

    unsigned bofPosition() const;
    void setBofPosition( unsigned bofPosition );

    UString sheetName() const;
    void setSheetName( UString sheetName );

    unsigned sheetNameLength() const;
    void setSheetNameLength( unsigned sheetNameLength );

    SheetState sheetState() const;
    void setSheetState( SheetState sheetState );

    SheetType sheetType() const;
    void setSheetType( SheetType sheetType );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "BoundSheet"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class CalcModeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    CalcModeRecord();
    virtual ~CalcModeRecord();

    CalcModeRecord( const CalcModeRecord& record );
    CalcModeRecord& operator=( const CalcModeRecord& record );

    enum CalcMode {
        Manual = 0,
        Automatic = 1,
        SemiAutomatic = -1
    };

    static UString calcModeToString(CalcMode calcMode);

    CalcMode calcMode() const;
    void setCalcMode( CalcMode calcMode );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "CalcMode"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class ColInfoRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    ColInfoRecord();
    virtual ~ColInfoRecord();

    ColInfoRecord( const ColInfoRecord& record );
    ColInfoRecord& operator=( const ColInfoRecord& record );

    bool isCollapsed() const;
    void setCollapsed( bool collapsed );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    bool isHidden() const;
    void setHidden( bool hidden );

    unsigned lastColumn() const;
    void setLastColumn( unsigned lastColumn );

    unsigned outlineLevel() const;
    void setOutlineLevel( unsigned outlineLevel );

    unsigned width() const;
    void setWidth( unsigned width );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "ColInfo"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class DataTableRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    DataTableRecord();
    virtual ~DataTableRecord();

    DataTableRecord( const DataTableRecord& record );
    DataTableRecord& operator=( const DataTableRecord& record );

    enum Direction {
        InputRow,
        InputColumn,
        Input2D
    };

    static UString directionToString(Direction direction);

    bool isAlwaysCalc() const;
    void setAlwaysCalc( bool alwaysCalc );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned firstRow() const;
    void setFirstRow( unsigned firstRow );

    unsigned inputColumn1() const;
    void setInputColumn1( unsigned inputColumn1 );

    unsigned inputColumn2() const;
    void setInputColumn2( unsigned inputColumn2 );

    unsigned inputRow1() const;
    void setInputRow1( unsigned inputRow1 );

    unsigned inputRow2() const;
    void setInputRow2( unsigned inputRow2 );

    unsigned lastColumn() const;
    void setLastColumn( unsigned lastColumn );

    unsigned lastRow() const;
    void setLastRow( unsigned lastRow );

    bool isRowColTable() const;
    void setRowColTable( bool rowColTable );

    bool isRowInput() const;
    void setRowInput( bool rowInput );

    Direction direction() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "DataTable"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class DateModeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    DateModeRecord();
    virtual ~DateModeRecord();

    DateModeRecord( const DateModeRecord& record );
    DateModeRecord& operator=( const DateModeRecord& record );

    bool isBase1904() const;
    void setBase1904( bool base1904 );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "DateMode"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class DimensionRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    DimensionRecord();
    virtual ~DimensionRecord();

    DimensionRecord( const DimensionRecord& record );
    DimensionRecord& operator=( const DimensionRecord& record );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned firstRow() const;
    void setFirstRow( unsigned firstRow );

    unsigned lastColumnPlus1() const;
    void setLastColumnPlus1( unsigned lastColumnPlus1 );

    unsigned lastRowPlus1() const;
    void setLastRowPlus1( unsigned lastRowPlus1 );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Dimension"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class ExternSheetRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    ExternSheetRecord();
    virtual ~ExternSheetRecord();

    ExternSheetRecord( const ExternSheetRecord& record );
    ExternSheetRecord& operator=( const ExternSheetRecord& record );

    unsigned bookRef( unsigned index ) const;
    void setBookRef( unsigned index, unsigned bookRef );

    unsigned firstSheetRef( unsigned index ) const;
    void setFirstSheetRef( unsigned index, unsigned firstSheetRef );

    unsigned lastSheetRef( unsigned index ) const;
    void setLastSheetRef( unsigned index, unsigned lastSheetRef );

    unsigned refCount() const;
    void setRefCount( unsigned refCount );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "ExternSheet"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class FontRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    FontRecord();
    virtual ~FontRecord();

    FontRecord( const FontRecord& record );
    FontRecord& operator=( const FontRecord& record );

    enum Escapement {
        Normal = 0,
        Superscript = 1,
        Subscript = 2
    };

    static UString escapementToString(Escapement escapement);

    enum Underline {
        None = 0,
        Single = 1,
        Double = 2,
        SingleAccounting = 0x21,
        DoubleAccounting = 0x22
    };

    static UString underlineToString(Underline underline);

    enum FontFamily {
        Unknown = 0,
        Roman = 1,
        Swiss = 2,
        Modern = 3,
        Script = 4,
        Decorative = 5
    };

    static UString fontFamilyToString(FontFamily fontFamily);

    unsigned characterSet() const;
    void setCharacterSet( unsigned characterSet );

    unsigned colorIndex() const;
    void setColorIndex( unsigned colorIndex );

    bool isCondensed() const;
    void setCondensed( bool condensed );

    Escapement escapement() const;
    void setEscapement( Escapement escapement );

    bool isExtended() const;
    void setExtended( bool extended );

    FontFamily fontFamily() const;
    void setFontFamily( FontFamily fontFamily );

    UString fontName() const;
    void setFontName( UString fontName );

    unsigned fontNameLength() const;
    void setFontNameLength( unsigned fontNameLength );

    unsigned fontWeight() const;
    void setFontWeight( unsigned fontWeight );

    unsigned height() const;
    void setHeight( unsigned height );

    bool isItalic() const;
    void setItalic( bool italic );

    bool isOutline() const;
    void setOutline( bool outline );

    bool isShadow() const;
    void setShadow( bool shadow );

    bool isStrikeout() const;
    void setStrikeout( bool strikeout );

    Underline underline() const;
    void setUnderline( Underline underline );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Font"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class HeaderRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    HeaderRecord();
    virtual ~HeaderRecord();

    HeaderRecord( const HeaderRecord& record );
    HeaderRecord& operator=( const HeaderRecord& record );

    UString header() const;
    void setHeader( UString header );

    unsigned headerLength() const;
    void setHeaderLength( unsigned headerLength );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Header"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class FooterRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    FooterRecord();
    virtual ~FooterRecord();

    FooterRecord( const FooterRecord& record );
    FooterRecord& operator=( const FooterRecord& record );

    UString footer() const;
    void setFooter( UString footer );

    unsigned footerLength() const;
    void setFooterLength( unsigned footerLength );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Footer"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class FormatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    FormatRecord();
    virtual ~FormatRecord();

    FormatRecord( const FormatRecord& record );
    FormatRecord& operator=( const FormatRecord& record );

    UString formatString() const;
    void setFormatString( UString formatString );

    unsigned formatStringLength() const;
    void setFormatStringLength( unsigned formatStringLength );

    unsigned index() const;
    void setIndex( unsigned index );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Format"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class LabelRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    LabelRecord();
    virtual ~LabelRecord();

    LabelRecord( const LabelRecord& record );
    LabelRecord& operator=( const LabelRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    UString label() const;
    void setLabel( UString label );

    unsigned labelLength() const;
    void setLabelLength( unsigned labelLength );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Label"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class LabelSSTRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    LabelSSTRecord();
    virtual ~LabelSSTRecord();

    LabelSSTRecord( const LabelSSTRecord& record );
    LabelSSTRecord& operator=( const LabelSSTRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned sstIndex() const;
    void setSstIndex( unsigned sstIndex );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "LabelSST"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class MergedCellsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    MergedCellsRecord();
    virtual ~MergedCellsRecord();

    MergedCellsRecord( const MergedCellsRecord& record );
    MergedCellsRecord& operator=( const MergedCellsRecord& record );

    unsigned count() const;
    void setCount( unsigned count );

    unsigned firstColumn( unsigned index ) const;
    void setFirstColumn( unsigned index, unsigned firstColumn );

    unsigned firstRow( unsigned index ) const;
    void setFirstRow( unsigned index, unsigned firstRow );

    unsigned lastColumn( unsigned index ) const;
    void setLastColumn( unsigned index, unsigned lastColumn );

    unsigned lastRow( unsigned index ) const;
    void setLastRow( unsigned index, unsigned lastRow );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "MergedCells"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class MulBlankRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    MulBlankRecord();
    virtual ~MulBlankRecord();

    MulBlankRecord( const MulBlankRecord& record );
    MulBlankRecord& operator=( const MulBlankRecord& record );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned lastColumn() const;
    void setLastColumn( unsigned lastColumn );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex( unsigned index ) const;
    void setXfIndex( unsigned index, unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "MulBlank"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class NumberRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    NumberRecord();
    virtual ~NumberRecord();

    NumberRecord( const NumberRecord& record );
    NumberRecord& operator=( const NumberRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    double number() const;
    void setNumber( double number );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Number"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class PaletteRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    PaletteRecord();
    virtual ~PaletteRecord();

    PaletteRecord( const PaletteRecord& record );
    PaletteRecord& operator=( const PaletteRecord& record );

    unsigned blue( unsigned index ) const;
    void setBlue( unsigned index, unsigned blue );

    unsigned count() const;
    void setCount( unsigned count );

    unsigned green( unsigned index ) const;
    void setGreen( unsigned index, unsigned green );

    unsigned red( unsigned index ) const;
    void setRed( unsigned index, unsigned red );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Palette"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class RowRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    RowRecord();
    virtual ~RowRecord();

    RowRecord( const RowRecord& record );
    RowRecord& operator=( const RowRecord& record );

    bool isCollapsed() const;
    void setCollapsed( bool collapsed );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned height() const;
    void setHeight( unsigned height );

    bool isHidden() const;
    void setHidden( bool hidden );

    unsigned lastColumnPlus1() const;
    void setLastColumnPlus1( unsigned lastColumnPlus1 );

    unsigned outlineLevel() const;
    void setOutlineLevel( unsigned outlineLevel );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "Row"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

class StringRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const { return this->id; }

    StringRecord();
    virtual ~StringRecord();

    StringRecord( const StringRecord& record );
    StringRecord& operator=( const StringRecord& record );

    unsigned stringLength() const;
    void setStringLength( unsigned stringLength );

    UString ustring() const;
    void setUstring( UString ustring );

    Value value() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions );

    virtual const char* name() const { return "String"; }

    virtual void dump( std::ostream& out ) const;

private:
    class Private;
    Private * const d;
};

} // namespace Swinder

#endif // SWINDER_RECORDS_H
