using GLib;
using Soup;
using Xml;

public class XMList {

	private int total_pages;
	private int current_page;
	private HashTable[] list;
	private Xml.Node* root_node;
	private int count;
	
	public XMList(string xml)
	{
		count = 0;
		list = new HashTable[0];
		if (xml != null && xml.contains("<?xml"))
		{
		
			Doc* doc = Parser.read_doc(xml.strip(), null, "utf-8", Xml.ParserOption.RECOVER);
			if (doc != null)
			{
				root_node = doc->get_root_element ();
				if (root_node == null) {
				    delete doc;
				    return;
				}
				for (Xml.Node* iter = root_node->children; iter != null; iter = iter->next) {
				    //spaces btw. tags are also nodes, discard them
				    if (iter->type != ElementType.ELEMENT_NODE)
					continue;
				    string node_name = iter->name; //get the node's name
				    if (node_name == "items")
				    {
					for (Xml.Node* iter2 = iter->children; iter2 != null; iter2 = iter2->next) {
					    //spaces btw. tags are also nodes, discard them
					    if (iter2->type != ElementType.ELEMENT_NODE)
						continue;
						HashTable<string,string> ht;
						ht = new HashTable<string,string>(str_hash, str_equal);
						for (Xml.Node* iter3 = iter2->children; iter3 != null; iter3 = iter3->next)
						{
							string node_name2 = iter3->name; //get the node's name
							string node_content = iter3->get_content();
							ht.insert(node_name2, node_content);
						}
						list += ht;
						count += 1;
					}
				    }
				    else
				    if (node_name == "pages")
				    {
					for (Xml.Node* iter2 = iter->children; iter2 != null; iter2 = iter2->next)
					{
					    //spaces btw. tags are also nodes, discard them
					    if (iter2->type != ElementType.ELEMENT_NODE)
						continue;
				
					    string node_name2 = iter2->name; //get the node's name
					    string node_content = iter2->get_content();
					    if (node_name2 == "current")
						current_page = node_content.to_int();
					    else
					    if (node_name2 == "total")
						total_pages = node_content.to_int();
					}
				    }
				}
				delete doc;
			}
		}
		//free the document
		
	}
	
	public int itemcount()
	{
		return count;
	}
	
	public HashTable[] items()
	{
		return this.list;
	}
	
	public int pages()
	{
		return this.total_pages;
	}
	
	public int page()
	{
		return this.current_page;
	}
	
}
