using GLib;
using Gtk;

public class Scroller : Gtk.ScrolledWindow
{
	Viewport scroll;
	Gtk.Container container;
	private bool clicking;
	TimeVal last_scrolling;
	uint kinetic_scroller_id;
	private bool moved;
	private bool vertical_scroll;
	private bool horizontal_scroll;
	private bool clicking_enabled;
	int kinetic_refresh_millis;
	double kinetic_friction;
	double ox;
	double oy;
	double dx;
	double dy;
	double gdx;
	double gdy;
	double oox;
	double ooy;
	bool moving;
	bool moving2;
	bool scrolloff;
	bool scrolloff2;
	bool wasbtn;
	private int drag_start_x;
	private int drag_start_y;

	construct {
		clicking_enabled = true;
		vertical_scroll = true;
		horizontal_scroll = true;
		this.kinetic_friction = 0.95;
		this.kinetic_refresh_millis = 20;
		this.moving = false;
		this.moving2 = false;
	}
	
	public Scroller(Gtk.Container container)
	{
		EventBox eb = new EventBox();
		change_background_color(eb, "#000");
		eb.add(container);
		this.container = container;
		this.clicking = false;
		set_policy (PolicyType.NEVER, PolicyType.NEVER);
		scroll = new Gtk.Viewport(null, null);
		scroll.add(eb);
		this.add(scroll);
		eb.motion_notify_event += (widget, event) => {
			return scroll_motion(widget, event);
		};
		eb.button_press_event += (widget, event) => {
			return scroll_pressed(widget, event);
		};
		eb.button_release_event += (widget, event) => {
			return scroll_released(widget, event);
		};
		this.change_background_color(this, "#000000");
		this.change_background_color(scroll, "#000000");
	}
	
	
	void do_scroll(int x, int y, bool kinetic)
	{
	    Gtk.Adjustment adj;
	    double newval, maxval;
	    TimeVal now = TimeVal();
	
	    if (gdx > 15)
	    {
		adj = this.hadjustment;
		maxval = adj.upper - adj.page_size;
		newval = adj.value - (x - ox);
		if (newval > maxval)
			newval = maxval;
		if (newval < 0)
			newval = 0;
		if (kinetic && (newval == 0 || newval == maxval))
			dx = 0;
		adj.value = newval;
	    }
	
	    if (gdy > 15)
	    {
		adj = this.vadjustment;
		maxval = adj.upper - adj.page_size;
		newval = adj.value - (y - oy);
		if (newval > maxval)
			newval = maxval;
		if (newval < 0)
			newval = 0;
		if (kinetic && (newval == 0 || newval == maxval))
			dy = 0;
		adj.value = newval;
	    }
	
	    now.get_current_time();
	    long time_passed = (now.tv_sec - last_scrolling.tv_sec) * 1000000
				+ now.tv_usec - last_scrolling.tv_usec;
	
	    if (kinetic)
	    {
		double delay = time_passed / (kinetic_refresh_millis * 1000);
		dx *= GLib.Math.pow(kinetic_friction, delay);
		dy *= GLib.Math.pow(kinetic_friction, delay);
			last_scrolling.tv_sec = now.tv_sec;
			last_scrolling.tv_usec = now.tv_usec;
	    }
	    else if (time_passed > 7000)
	    {
			dx = (dx + (x - oox) * 16000 / time_passed) / 3;
			dy = (dy + (y - ooy) * 16000 / time_passed) / 3;
			oox = ox;
			ooy = oy;
		    last_scrolling.tv_sec = now.tv_sec;
		    last_scrolling.tv_usec = now.tv_usec;
		}
	
	    ox = x;
	    oy = y;
	}
	
	bool kinetic_scroll_cb()
	{
		if (kinetic_scroller_id == 0)
			return false;
	
		do_scroll((int)(ox + dx), (int)(oy + dy), true);
		return GLib.Math.fabs(dx) > 1 || GLib.Math.fabs(dy) > 1;
	}

	
	public void enable_clicking(bool clicking_enabled)
	{
		this.clicking_enabled = clicking_enabled;
	}
	
	public void set_scroll_policy(bool h, bool v)
	{
		horizontal_scroll = h;
		vertical_scroll = v;
	}
	
	public void change_background_color(Widget widget, string col)
	{
		/*
		Gdk.Color color;
		Gdk.Color.parse(col, out color);
		widget.modify_bg (Gtk.StateType.NORMAL, color);
		widget.modify_base (Gtk.StateType.NORMAL, color);
		*/
		
	}
	
	public bool window_scrolled()
	{
		return moved;
	}
	
	public Gtk.Container get_container()
	{
		return container;
	}
	
	public void click_on(int x, int y, GLib.TimeVal newtime)
	{
		if (clicking_enabled)
		{
			var children = this.container.get_children();
			foreach (Widget child in children) {
				Gtk.Allocation al = child.allocation;
				if (x >= al.x && x <= al.x + al.width)
				{
					if (y >= al.y && y <= al.y + al.height)
					{
						if (child is Item)
						{
							Item i = (Item)child;
							i.item_selected(null, 0);
							if (i.get_item_type() != Item.BUTTON)
								enable_clicking(false);
							break;
						}
					}
				}
			}
		}
	}
	
	bool scroll_pressed (Widget w, Gdk.EventButton ev)
	{
		this.moved = false;
		int px, py;
		this.get_pointer(out px, out py);
		this.drag_start_x = px;
		this.drag_start_y = py;
		double ev_x = (double)px;
		double ev_y = (double)py;
		this.kinetic_scroller_id = 0;
		if (scrolloff)
		{
			wasbtn = true;
			return false;
		}
		if (GLib.Math.fabs(ev_x-ox) < 10 && GLib.Math.fabs(ev_y - oy) < 10 && !moving2)
		{
			scrolloff2 = true;
			return false;
		}
		
		last_scrolling.get_current_time();
		ox = oox = ev_x;
		oy = ooy = ev_y;
		gdx = gdy = 0;
		dx = dy = 0;
		moving = true;
		moving2 = false;
		
		return true;
	}
	
	bool scroll_released (Widget w, Gdk.EventButton ev)
	{
		int px, py;
		this.get_pointer(out px, out py);
		if (scrolloff2)
		{
			scrolloff2 = false;
			return false;
		}
		if (moving && !moving2)
		{
			/*
			ev.send_event = true;
			bool b = false;
			this.emit_by_name(sw.page, "button_press_event", &ev, &b);
			*/
		}
		
		bool res = moving2;
		moving = false;
		if (moving2)
		{
			if (GLib.Math.fabs(dx) < 5)
				dx = 0;
			if (GLib.Math.fabs(dy) < 5)
				dy = 0;
			if (dx != 0 || dy != 0) {
				kinetic_scroll_cb();
			    this.kinetic_scroller_id = GLib.Timeout.add(kinetic_refresh_millis, kinetic_scroll_cb);
		}
		this.grab_focus();
		}
		else
		if (!moved)
		{
			int x, y;
			this.get_pointer(out x, out y);
			x += (int)this.hadjustment.value;
			y += (int)this.vadjustment.value;
			click_on(x, y, last_scrolling);
		}
		moving2 = false;
		return res;
	}
	
	bool scroll_motion (Widget w, Gdk.EventMotion ev)
	{
		int px, py;
		this.get_pointer(out px, out py);
		if (px - drag_start_x > 20 || px - drag_start_x < -20 || py - drag_start_y > 20 || py - drag_start_y < -20)
			this.moved = true;
		double ev_x = (double)px;
		double ev_y = (double)py;
		if (!moving || (ev_x == ox && ev_y == oy))
			return false;
		
		    if (!moving2)
		    {
			gdx += GLib.Math.fabs(ev_x - ox);
			gdy += GLib.Math.fabs(ev_y - oy);
		
			if (gdx > 20 || gdy > 20)
			{
			    moving2 = true;
			    moved = true;
			}
			else
			{
			    ox = ev_x;
			    oy = ev_y;
			    return true;
			}
		    }
		
		    do_scroll((int)ev_x, (int)ev_y, false);
		    return true;	
	}
	
	public bool busy()
	{
		return moving || moving2;
	}
	
	public void scroll_up()
	{
		double value = this.vadjustment.page_increment;
		if (this.vadjustment.value - value < 0)
			value = this.vadjustment.value;
		this.vadjustment.value -= value;
	}
	
	public void scroll_down()
	{
		double value = this.vadjustment.page_increment;
		if (this.vadjustment.value + this.allocation.height + value > this.vadjustment.upper)
			value = this.vadjustment.upper - this.allocation.height - this.vadjustment.value;
		this.vadjustment.value += value; 
	}
	
	public void scroll_to_top()
	{
		this.vadjustment.value = 0;
		this.hadjustment.value = 0;
	}
	
}
