using GLib;
using Gtk;
using Hildon;
using Gdk;

public class Info : PageWidget
{
	Gtk.Image image;
	Label plot;
	Gtk.ToolButton clear_position_button;
	int id;
	private string info;
	private Item item;
	
	public override void add_signals()
	{
		get_toolbar_button(0).clicked += () => {
			this.hide_info();
		};
		get_toolbar_button(1).clicked += () => {
			this.get_knots().get_player().play(this.id.to_string(), this.get_knots().get_player().ITEM);
		};
		get_toolbar_button(2).clicked += () => {
			this.get_knots().get_player().play(this.id.to_string(), this.get_knots().get_player().ARTIST);
		};
		get_toolbar_button(3).clicked += () => {
			this.get_knots().get_player().play(this.id.to_string(), this.get_knots().get_player().ALBUM);
		};
		get_toolbar_button(4).clicked += () => {
			this.get_knots().get_playlist().add_to_playlist(this.id);
			if (get_knots().get_playlist().playlist_contains_item(this.id))
			{
				get_toolbar_button(4).hide();
				get_toolbar_button(5).show();
			}
		};
		get_toolbar_button(5).clicked += () => {
			
			if (item.get_item_attribute("pid") == null)
				this.get_knots().get_playlist().remove_item_from_playlist(this.id);
			else
				this.get_knots().get_playlist().remove_from_playlist(((string)item.get_item_attribute("pid")).to_int());
			
			if (item.get_item_attribute("pid") != null || !get_knots().get_playlist().playlist_contains_item(this.id))
			{
				get_toolbar_button(4).show();
				get_toolbar_button(5).hide();
				if (item.get_item_attribute("pid") != null)
					hide_info();
			}
		};
	}
	
	public override Gtk.Widget create_content()
	{
		clear_position_button = new Gtk.ToolButton(new Gtk.Image.from_file("/usr/share/knots/knots_button_clear_position.png"), "");
		clear_position_button.clicked += () => {
			clear_position();
		};
		image = new Gtk.Image();
		EventBox eb2 = new EventBox();
		eb2.button_release_event += regrab_image;
		eb2.add(image);
		plot = new Gtk.Label("Plot");
		plot.set_line_wrap(true);
		get_knots().change_foreground_color(plot, "#fff");
		Gtk.VBox f = new Gtk.VBox(false, 10);
		Gtk.HBox h = new Gtk.HBox(true, 10);
		h.pack_start(eb2, false, false, 10);
		h.pack_start(clear_position_button, false, false, 10);
		f.pack_start(h, false, false, 10);
		f.pack_start(plot, false, false, 10);
		Scroller scroller = new Scroller(f);
		scroller.set_scroll_policy(false, true);
		return scroller;
	}
	
	public bool regrab_image(Gdk.EventButton eb)
	{
		if (!((Scroller)get_content()).window_scrolled())
		{
			if (item != null)
			{
				get_knots().alert("Grabbing new image");
				item.refetch_screenshot();
			}
		}
		return false;
	}
	
	public override string[] get_toolbar_items()
	{
		return {"back", "play", "play_artist", "play_album", "add_to_playlist", "remove_from_playlist"};
	}
	
	public void show_info(Item? item)
	{
		get_knots().get_jump_to_button().hide();
		get_knots().get_play_results_button().hide();
		get_knots().get_add_results_button().hide();
		if (item != null)
		{
			this.item = item;
			this.reveal();
		}
		this.id = this.item.get_item_id();
		if (get_knots().get_playlist().playlist_contains_item(id))
		{
			get_toolbar_button(4).hide();
			get_toolbar_button(5).show();
		}
		else
		{
			get_toolbar_button(4).show();
			get_toolbar_button(5).hide();
			get_toolbar_button(4).set_sensitive(get_knots().get_playlist().can_add_to_playlist(this.item.get_item_attribute("mediatype").to_int()));
			
		}
		if (this.item.get_item_attribute("mediatype").to_int() != 1)
		{
			get_toolbar_button(2).set_sensitive(false);
			get_toolbar_button(3).set_sensitive(false);
		}
		else
		{
			get_toolbar_button(2).set_sensitive(true);
			get_toolbar_button(3).set_sensitive(true);
		}
		image.set_from_pixbuf(this.item.get_default_image());
		update_info(null);
	}
	
	public override void orientation_change()
	{
		base.orientation_change();
		if (info != null)
			update_info(info);
	}
	
	public override void reveal()
	{
		base.reveal();
		get_knots().setTagTitle(false);
		get_knots().get_tag_button().show();
		if (this.item.get_item_attribute("mediatype").to_int() == 0)
			get_knots().get_subtitle_button().show();	
	}
	
	public void tag_item()
	{
		bool active = true;
		bool was_tagged = false;
		string tagged = get_knots().visible_page(this) ? item_id().to_string() : get_knots().get_browser().get_item_ids();
		get_knots().get_connection().set_url_cache(false);
		XMList list = new XMList(get_knots().get_connection().fetch("/external/all_tags"));
		var tagids = new int[0];
		var tag_values = new string[0];
		var valueids = new int[0];
		var value_values = new string[0];
		var dialog = new PickerDialog (get_knots().get_window());
		dialog.set_title("Tag " + (get_knots().visible_page(this) ? item.get_item_attribute("name") : " multiple items"));
		Hildon.Entry tag_text = new Hildon.Entry(SizeType.FINGER_HEIGHT);
		Hildon.Entry value_text = new Hildon.Entry(SizeType.FINGER_HEIGHT);
		Hildon.Button tag_item = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Tag", "");
		tag_item.clicked += () => {
			if (tag_items_with(tagged, tag_text.get_text(), value_text.get_text()))
				was_tagged = true;
		};
		dialog.height_request = 440;
		dialog.set_done_label("Cancel");
		dialog.action_area.pack_start(tag_text, false, true, 1);
		dialog.action_area.pack_start(value_text, false, true, 1);
		dialog.action_area.pack_start(tag_item, false, true, 1);
		dialog.action_area.show_all();
		ListStore tags = new ListStore (1, typeof (string));
		TreeIter iter;
		foreach(HashTable<string,string> ht in list.items())
		{
			tags.append (out iter);
			tags.set_value(iter, 0, (string)ht.lookup("tag"));
			tagids += ((string)ht.lookup("id")).to_int();
			tag_values += (string)ht.lookup("tag");
		}
		ListStore values = new ListStore (1, typeof (string));
		var selector = new TouchSelector ();
		selector.append_text_column (tags, true);
		selector.append_text_column (values, true);
		dialog.set_selector (selector);
		selector.changed += (col) => {
			if (active && col == 0 && selector.get_active(col) >= 0)
			{
				selector.remove_column(1);
				values = new ListStore (1, typeof (string));
				selector.append_text_column (values, true);
				int id = tagids[selector.get_active(col)];
				XMList list2 = new XMList(get_knots().get_connection().fetch("/external/all_values_for_tag?id=" + id.to_string()));
				if (list2.itemcount() > 0)
				{
					int index = 0;
					TreeIter iter2;
					foreach(HashTable<string,string> ht2 in list2.items())
					{
						values.append (out iter2);
						values.set_value(iter2, 0, (string)ht2.lookup("value"));
						valueids += ((string)ht2.lookup("id")).to_int();
						if (index < value_values.length)
							value_values[index] = (string)ht2.lookup("value");
						else
							value_values += (string)ht2.lookup("value");
						index += 1;
					}
				}
				else
				{
					get_knots().alert("No values for this tag");
					
				}
				tag_text.set_text(tag_values[selector.get_active(col)]);
				value_text.set_text("");
				selector.unselect_all(1);
			}
			else
			if (col == 1 && selector.get_active(col) >= 0)
			{
				value_text.set_text(value_values[selector.get_active(col)]);
			}
		};
		selector.unselect_all(0);
		dialog.run();
		active = false;
		dialog.destroy();
		if (get_knots().visible_page(this) && was_tagged)
			update_info(null);
	}
	
	public bool tag_items_with(string items, string tag, string value)
	{
		if (tag != null && tag.length > 0 && value != null && value.length > 0)
		{
			string data = get_knots().get_connection().fetch("/external/tag_item?id=" + items + "&tag=" + Soup.URI.encode(tag, "") + "&value=" + Soup.URI.encode(value, ""));
			if (data != null && data.str("OK") != null)
			{
				if (data.str("OK_ALBUM") == null)
					get_knots().alert("Tagging successful");
				else
				{
					get_knots().alert("Tagging successful. Album art applied to all tagged items.");
					get_knots().get_common().clear_cache(1);	
				}
				return true;
			}
			else
			{
				get_knots().alert("Tagging failed");
			}
		}
		else
			get_knots().alert("Please fill both tag and value");
		return false;
	}
	
	public void fetch_subtitles()
	{
		string[] ids = new string[0];
		string[] exts = new string[0];
		get_knots().get_connection().set_url_cache(false);
		XMList list = new XMList(get_knots().get_connection().fetch("/external/subtitles?id=" + this.id.to_string()));
		if (list.itemcount() > 0)
		{
			var dialog = new PickerDialog (get_knots().get_window());
			gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
			dialog.set_title ("Select the subtitle");
			ListStore subtitlelist = new ListStore (1, typeof (string));
			TreeIter iter;
			foreach(HashTable<string,string> ht in list.items())
			{
				subtitlelist.append (out iter);
				subtitlelist.set_value (iter, 0, (string)ht.lookup("name"));
				ids += (string)ht.lookup("id");
				exts += (string)ht.lookup("ext");
			}
			var selector = new TouchSelector ();
			selector.append_text_column (subtitlelist, true);
			dialog.set_selector (selector);
			selector.unselect_all(0);
			var res = dialog.run ();
			if (res == ResponseType.OK)
			{
				int sel = selector.get_active(0);
				get_knots().get_connection().set_url_cache(false);
				string resp = get_knots().get_connection().fetch("/external/download_sub?id=" + this.id.to_string() + "&subid=" + ids[sel] + "&ext=" + exts[sel]);
				if (resp != null && resp.str("OK") != null)
					get_knots().alert("Download successful");
				else
					get_knots().alert("Download failed");
					
			}
			dialog.destroy ();
		}
		else
		{
			get_knots().alert("No subtitles found");
		}
	}
	
	public int item_id()
	{
		return this.id;
	}
	
	public void load_image()
	{
		if (this.item != null)
		{
			image.set_from_pixbuf(this.item.get_default_image());
		}
	}
	
	public void update_info(string? fetched_info)
	{
		load_image();
		plot.set_label("");
		if (fetched_info == null)
		{
			get_knots().get_connection().set_url_cache(false);
			info = get_knots().get_connection().fetch("/external/info?id=" + this.id.to_string());
			if(info != null && info.str("Resume position") != null)
				clear_position_button.show();
			else
				clear_position_button.hide();
			plot.set_markup(info);
		}
		else
		{
			plot.set_markup(fetched_info);
		}
		((Scroller)get_content()).scroll_to_top();
	}
	
	public void clear_position()
	{
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch("/external/clear_position?id=" + this.id.to_string());
		update_info(null);
	}
	
	public string humanize_duration(int duration)
	{
		return timefy(duration / 60 / 60 % 60) + ":" + timefy(duration / 60 % 60) + ":" + timefy(duration % 60);
	}
	
	public string timefy(int val)
	{
		if (val < 10)
			return "0" + val.to_string();
		else
			return val.to_string();
	}
	
	public void hide_info()
	{
		get_knots().get_tag_button().hide();
		get_knots().get_subtitle_button().hide();
		if (item.get_item_attribute("pid") == null)
			this.get_knots().get_browser().reveal();
		else
			this.get_knots().get_playlist().reveal();
	}
}
