using GLib;
using Gtk;
using Hildon;

public class Playlist : PageWidget
{	
	private XMList playlists;
	private XMList itemlist;
	Item[] itemslist;
	int x;
	int y;
	Scroller scroller;
	private bool needs_update;
	private bool reordering;
	private Item[] swapped;
	
	construct
	{
		needs_update = true;
	}
	
	public override void add_signals()
	{
		get_toolbar_button(0).clicked += () => {
			this.get_knots().get_browser().reveal();
		};
		get_toolbar_button(1).clicked += () => {
			this.get_knots().get_player().play(this.get_selected_playlist_id().to_string(), this.get_knots().get_player().PLAYLIST);
		};
		get_toolbar_button(2).clicked += () => {
			reorder();
		};
		get_toolbar_button(3).clicked += () => {
			new_playlist();
		};
		get_toolbar_button(4).clicked += () => {
			delete_playlist();
		};
	}
	
	public void reorder()
	{
		if (reordering)
		{
			for (int i = 0; i < swapped.length; i++)
			{
				swapped[i].lowlight();
			}
			swapped = {};
		}
		
		var children = scroller.get_container().get_children();
		foreach (Gtk.Widget child in children)
		{
			if (child is Item)
			{
				if (!reordering)
					((Item)child).button_release_event += swap_order;
				else
					((Item)child).button_release_event -= swap_order;
			}
		}
		for (int i = 0; i < 5; i++)
		{
			if (i != 2)
				get_toolbar_button(i).set_sensitive(reordering);
		}
		if (!reordering)
			get_knots().alert("Click on items to swap them");
		scroller.set_scroll_policy(false, reordering);
		get_playlist_widget().set_sensitive(reordering);
		scroller.enable_clicking(reordering);
		reordering = !reordering;
		
	}
	
	public override void orientation_change()
	{
		base.orientation_change();
		re_add_items();
	}
	
	public bool swap_order(Gtk.Widget w, Gdk.EventButton e)
	{
		Item item = (Item)w;
		swapped += item;
		item.highlight();
		if (swapped.length == 2)
		{
			if (swapped[0] != swapped[1])
			{
				get_knots().get_connection().set_url_cache(false);
				get_knots().get_connection().fetch("/external/swap_playlist_items?pid=" + swapped[0].get_item_attribute("pid") + "&with=" + swapped[1].get_item_attribute("pid"));
				Gtk.Allocation first = swapped[0].allocation;
				((Gtk.Fixed)scroller.get_container()).move(swapped[0], swapped[1].allocation.x, swapped[1].allocation.y);
				((Gtk.Fixed)scroller.get_container()).move(swapped[1], first.x, first.y);
			}
			for (int i = 0; i < swapped.length; i++)
			{
				swapped[i].lowlight();
			}
			swapped = {};
		}
		return false;
	}
	
	public void new_playlist()
	{
		MessageDialog dialog = new MessageDialog.with_markup(null, 0, Gtk.MessageType.QUESTION, Gtk.ButtonsType.OK_CANCEL, "Playlist name");
		gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
		dialog.set_image(new Gtk.Image.from_file("/usr/share/knots/knots_button_playlist.png"));
		Hildon.Entry playlist_name = new Hildon.Entry(SizeType.FINGER_HEIGHT);
		dialog.vbox.pack_start(playlist_name, true, true, 1);
		playlist_name.show();
		var response = dialog.run();
		if (response == ResponseType.OK)
		{
			get_knots().get_connection().set_url_cache(false);
			string pid = get_knots().get_connection().fetch("/external/new_playlist?name=" + playlist_name.get_text());
			update_playlists();
			select_playlist(pid.to_int());
			update_items();
		}
		dialog.destroy();
	}
	
	public void delete_playlist()
	{
		MessageDialog dialog = new MessageDialog.with_markup(null, 0, Gtk.MessageType.QUESTION, Gtk.ButtonsType.OK_CANCEL, "Are you sure you want to delete this playlist?");
		gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
		dialog.set_image(new Gtk.Image.from_file("/usr/share/knots/knots_button_playlist.png"));
		var response = dialog.run();
		if (response == ResponseType.OK)
		{
			clear_list();
			get_knots().get_connection().set_url_cache(false);
			get_knots().get_connection().fetch("/external/delete_playlist?id=" + get_selected_playlist_id().to_string());
			update_playlists();
			select_playlist(1);
			update_items();
		}
		dialog.destroy();
	}
	
	public override Gtk.Widget create_content()
	{
		Gtk.VBox vb = new Gtk.VBox(false, 0);
		Hildon.Button cb = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, "Current playlist", "");
		cb.clicked += change_playlist;
		vb.pack_start(cb, false, true, 2);
		Gtk.Fixed f = new Gtk.Fixed();
		scroller = new Scroller(f);
		vb.pack_start(scroller, true, true, 0);
		return vb;
	}
	
	public void change_playlist()
	{
		if (playlists.itemcount() > 1)
		{
			var dialog = new PickerDialog (get_knots().get_window());
			gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
			dialog.set_title ("Select playlist");
			ListStore playlistnames = new ListStore (1, typeof (string));
			TreeIter iter;
			int index = 0;
			int selected = 0;
			foreach (HashTable ht in playlists.items())
			{
				string playlist_name = (string)ht.lookup("name");
				playlistnames.append (out iter);
				playlistnames.set_value (iter, 0, playlist_name);
				if (playlist_name == get_playlist_widget().get_value())
				{
					selected = index;
				}
				index += 1;
			}
			var selector = new TouchSelector ();
			selector.append_text_column (playlistnames, true);
			dialog.set_selector (selector);
			selector.set_active(0, selected);
			var res = dialog.run ();
			if (res == ResponseType.OK)
			{
				HashTable sp = playlists.items()[selector.get_active(0)];
				select_playlist((int)((string)sp.lookup("id")).to_int());
				update_items();
			}
			dialog.destroy ();
		}
	}
	
	public bool playlist_contains_item(int id)
	{
		if (itemlist != null)
		{
			foreach(HashTable ht in itemlist.items())
			{
				if (((string)ht.lookup("id")).to_int() == id)
					return true;
			}
		}
		return false;
	}
	
	public Hildon.Button get_playlist_widget()
	{
		return (Hildon.Button)((Gtk.VBox)get_content()).get_children().nth_data(0);
	}
	
	public void update_playlists()
	{
		get_knots().get_connection().set_url_cache(false);
		playlists = new XMList(get_knots().get_connection().fetch("/external/playlists"));
	}
	
	public void select_playlist(int id)
	{
		int index = 0;
		foreach (HashTable ht in playlists.items())
		{
			if (((string)ht.lookup("id")).to_int() == id)
			{
				get_playlist_widget().set_value((string)ht.lookup("name"));
				return;
			}
			index += 1;
		}
	}
	
	public int get_selected_playlist_id()
	{
		if (playlists != null)
		{
			foreach (HashTable ht in playlists.items())
			{
				string name = (string)ht.lookup("name");
				if (name == get_playlist_widget().get_value())
					return ((string)ht.lookup("id")).to_int();	
			}
		}
		return -1;
	}
	
	public void update_list()
	{
		get_knots().get_connection().set_url_cache(false);
		itemlist = new XMList(get_knots().get_connection().fetch("/external/playlist?id=" + get_selected_playlist_id().to_string()));
	}
	
	public void update_items()
	{
		if (get_selected_playlist_id() != -1)
		{
			clear_list();
			itemslist = new Item[0];
			int itemcount = 0;
			get_knots().get_connection().set_url_cache(false);
			itemlist = new XMList(get_knots().get_connection().fetch("/external/playlist?id=" + get_selected_playlist_id().to_string()));
			foreach(HashTable ht in itemlist.items())
			{
				Item item = new Item(get_knots(), ht, get_knots().get_browser().has_icon_view());
				item.create();
				itemslist += item;
				add_item(item);
				itemcount += 1;
			}
			scroller.get_container().show_all();
			needs_update = false;
			get_toolbar_button(1).set_sensitive(itemcount > 0);
			get_toolbar_button(2).set_sensitive(itemcount > 1);
		}
	}
	
	public void add_item(Item item)
	{	
		var ww = get_knots().get_screen_width();
		int item_count = ww / item.width();
		int gap = (ww - item_count * item.width()) / (item_count + 1);
		x += gap;
		((Gtk.Fixed)scroller.get_container()).put(item, x, y);
		x += item.width();
		if (x + item.width() > ww)
		{
			x = 0;
			y += item.height() + 5;
		}
	}
	
	public void re_add_items()
	{
		clear_list();
		foreach(Item item in itemslist)
		{
			add_item(item);
			if (!item.has_icon_view())
				item.new_width(get_knots().get_screen_width());
		}
	}
	
	public override string[] get_toolbar_items()
	{
		return {"back", "play", "reorder", "new", "delete"};
	}
	
	public void add_to_playlist(int id)
	{
		int pid = get_selected_playlist_id();
		if (pid == -1)
			pid = 1;
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch("/external/add_to_playlist?playlist=" + pid.to_string() + "&id=" + id.to_string());
		if (!get_knots().get_player().is_playing())
			get_knots().alert("Added to playlist");
		else
			get_knots().alert("Added to playlist. Restart playback to reload the playlist.");
		update_list();
		needs_update = true;
	}
	
	public void add_results_to_playlist(string ids)
	{
		int pid = get_selected_playlist_id();
		if (pid == -1)
			pid = 1;
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch("/external/add_results_to_playlist?playlist=" + pid.to_string() + "&ids=" + ids.to_string());
		if (!get_knots().get_player().is_playing())
			get_knots().alert("Added to playlist");
		else
			get_knots().alert("Added to playlist. Restart playback to reload the playlist.");
		update_list();
		needs_update = true;
	}
	
	public bool can_add_to_playlist(int mediatype)
	{
		/* don't mix audio and videos */
		foreach(Item item in itemslist)
		{
			int item_type = item.get_item_attribute("mediatype").to_int();
			if ((item_type != 1 && mediatype == 1) || (item_type == 1 && mediatype != 1))
			{
				return false;
			}
		}
		return true;
	}
	
	public void clear_list()
	{
		x = 0;
		y = 0;
		var children = scroller.get_container().get_children();
		foreach (Widget child in children) {
			scroller.get_container().remove(child);
		}
		scroller.scroll_to_top();
	}
	
	public void set_update_need(bool needs_update)
	{
		this.needs_update = needs_update;
	}
	
	public void remove_from_playlist(int id)
	{
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch("/external/remove_from_playlist?pid=" + id.to_string());
		update_items();
	}
	
	public void remove_item_from_playlist(int id)
	{
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch("/external/remove_from_playlist?playlist=" + get_selected_playlist_id().to_string() + "&id=" + id.to_string());
		update_items();
		get_knots().alert("Removed from playlist");
	}
	
	public override void reveal()
	{
		base.reveal();
		get_knots().get_window().queue_draw();
		scroller.enable_clicking(true);
		get_toolbar_button(1).set_sensitive(itemlist.itemcount() > 0);
		get_toolbar_button(2).set_sensitive(itemlist.itemcount() > 1);
		if (this.needs_update)
			update_items();
	}
}
