#ifndef CONTROL_H
#define CONTROL_H

/*
  Knips - A simple Camera program.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Images/Writer/JPEG.h>

#include <gst/gst.h>

#include <Lum/OS/Thread.h>

#include <Lum/OS/X11/SubWindow.h>

#include <Lum/Model/Action.h>

class VideoControl : public Lum::OS::X11::SubWindow
{
private:
  GstElement            *pipeline;    //! the gstreamer pipeline
  GstElement            *videoSource; //! The video source (webcam)
  GstElement            *videoSink;   //! the video sink (on screen output)
  GstElement            *imageSink;   //! the image sink (file output)
  guint                 callbackId;   //! Id of the "take photo" callback
  size_t                videoWidth;   //! Width of the video source and resulting images
  size_t                videoHeight;  //! Height of the video source and resulting images

  Lum::OS::Mutex        mutex;        //! Mutex to assure that we only take one photo at a time

  bool                  storeImage;   //! if true, the next frame should be stored
  Lum::Images::ImageRef image;
  bool                  done;         //! done with gstreamer initialisation

  Lum::Model::ActionRef gstMsg;       //! If triggered thgere is a GstMessage pending
  Lum::Model::ActionRef knips;        //! If triggered an image should be stored to disk
  Lum::Model::ActionRef knipsed;      //! If triggered an has been catched
  Lum::Model::ActionRef timer;        //! Timer to periodically check the camera orientation

private:
  void CheckCameraOrientation();

public:
  VideoControl();
  ~VideoControl();

  void GotImage(GstElement* imageSink, unsigned char *data);

  void SetKnipsAction(Lum::Model::Action* action);
  Lum::Model::Action* GetKnipsedAction() const;

  void GetImage(Lum::Images::ImageRef &image);

  void CalcSize();
  void Layout();

  void RequestImage();
  void CancelRequestImage();

  void OnGstMessage(GstMessage* message);
  bool HandleMouseEvent(const Lum::OS::MouseEvent& event);
  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
