/*
 * config.hpp
 *
 * Holds configuration options for the server program.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef CONFIG_HPP
#define CONFIG_HPP

#include <iosfwd>
#include <string>

class ConfigError {
public:
    ConfigError(int line_, const std::string &msg_) : line(line_), msg(msg_) { }
    int getLine() const { return line; }
    const std::string &getMessage() const { return msg; }
private:
    int line;
    std::string msg;
};
    
class Config {
public:
    // Load options from a config file
    explicit Config(std::istream &str);

    // Get the settings
    
    int getPort() const { return port; }
    const std::string & getDescription() const { return description; }
    std::string getMOTDFile() const { return motd_file; }
    
    int getMaxPlayers() const { return max_players; }
    int getMaxGames() const { return max_games; }
    
    bool getUseMetaserver() const { return metaserver; }
    bool getReplyToBroadcast() const { return broadcast; }

    const std::string & getPassword() const { return password; }  // empty if no password.

    const std::string & getKnightsDataDir() const { return knights_data_dir; }  // empty means use default (DATA_DIR or knights_data)
    const std::string & getLogFile() const { return log_file; }  // empty means print log to stdout.
    
private:
    int port;
    std::string description, motd_file;
    int max_players;   // must be > 0.
    int max_games;     // must be >= 0. 0 means unlimited.
    bool metaserver, broadcast;
    std::string password;
    std::string knights_data_dir;
    std::string log_file;
};
    
#endif
