/*
 * user_control.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef USER_CONTROL_HPP
#define USER_CONTROL_HPP

#include "map_support.hpp"

#include "network/byte_buf.hpp"  // coercri

#include <vector>

class Graphic;

class UserControl {
public:
    UserControl(int id_, const Graphic *menu_gfx, MapDirection menu_dir,
                int tap_pri, bool cts, unsigned int special)
        : id(id_), menu_graphic(menu_gfx), menu_direction(menu_dir),
          tap_priority(tap_pri), continuous(cts), menu_special(special)
    { }

    int getID() const { return id; }

    // If menu_graphic == 0 then this control won't appear on the
    // menu, else it will appear, preferably in the slot given by
    // getMenuDirection.
    const Graphic * getMenuGraphic() const { return menu_graphic; }
    MapDirection getMenuDirection() const { return menu_direction; }

    // If tap_priority > 0 then the action can be executed by tapping
    // fire. If more than one possible action has this then the one
    // with the highest tap_priority 'wins'.
    int getTapPriority() const { return tap_priority; }

    // "Continuous" controls (e.g. lock picking) are executed for as
    // long as you hold the button down. "Noncontinuous" controls
    // (e.g. opening a door) execute only once.
    bool isContinuous() const { return continuous; }

    // Special properties (only MS_WEAK at the moment)
    enum MenuSpecial { MS_WEAK=1 };
    unsigned int getMenuSpecial() const { return menu_special; }

    // serialization
    explicit UserControl(int id_, Coercri::InputByteBuf &buf, const std::vector<const Graphic *> &graphics);
    void serialize(Coercri::OutputByteBuf &buf) const;
    
private:
    int id;
    const Graphic *menu_graphic;
    MapDirection menu_direction;
    int tap_priority;
    unsigned int menu_special;
    bool continuous;
};

//
// Certain "standard" controls are given fixed ID numbers to help
// identify them.
//
// NOTE: These are the indices within the standard controls vector.
// The actual ID numbers are one plus this (because control IDs have
// to start from 1).
//

enum StandardControlIndex {
    SC_ATTACK = 0,
    SC_MOVE = 4,
    SC_WITHDRAW = 8,
    SC_SUICIDE = 9,
    NUM_STANDARD_CONTROLS = 10
};

#endif
