/*
 * status_display.hpp
 *
 * Interface for updates to a status display (the area that appears
 * below the main dungeon view, but not including the mini-map).
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef STATUS_DISPLAY_HPP
#define STATUS_DISPLAY_HPP

#include "potion_magic.hpp"

#include <string>
#include <vector>

class Graphic;

class StatusDisplay {
public:
    virtual ~StatusDisplay() { }

    //
    // Backpack
    // 
    // The game engine tells us a slot number, graphic to display in
    // that slot (from item_type->backpack_graphic), how many the
    // player is carrying, and the maximum that the player is allowed
    // to carry (or 0 for no maximum).
    // 
    // Slot conventions:
    // 11,12,... normal items.
    // 23 for the lock picks, and 20,21,22 for keys (one max of each).
    // 30 for gems.
    //
    virtual void setBackpack(int slot, const Graphic *gfx, const Graphic *overdraw,
                             int no_carried, int no_max) = 0;
    
    // Add a death (skull)
    virtual void addSkull() = 0;

    // Set health and potion-magic (controls colour of health bottle)
    virtual void setHealth(int h) = 0;
    virtual void setPotionMagic(PotionMagic pm, bool poison_immunity) = 0;

    // Set quest status info
    struct QuestIconInfo {
        int num_held, num_required;
        const Graphic *gfx_missing;
        const Graphic *gfx_held;
    };
    virtual void setQuestMessage(const std::string &msg) = 0;
    virtual void setQuestIcons(const std::vector<QuestIconInfo> &quest_icons) = 0;
};

#endif
