/*
 * sound.hpp
 *
 * Stores filename for a Sound.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SOUND_HPP
#define SOUND_HPP

#include "network/byte_buf.hpp"

#include <string>

class Sound {
public:
    Sound(int id_, const std::string &filename_)
        : id(id_), filename(filename_) { }

    int getID() const { return id; }
    const std::string & getFilename() const { return filename; }

    explicit Sound(int id_, Coercri::InputByteBuf &buf);
    void serialize(Coercri::OutputByteBuf &buf) const;
    
private:
    int id;
    std::string filename;
};

#endif
