/*
 * overlay.hpp
 *
 * Overlays are drawn over the top of an Anim and are used to draw
 * held items.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef OVERLAY_HPP
#define OVERLAY_HPP

#include "map_support.hpp"

class Graphic;

class Overlay {
public:
    explicit Overlay(int id_);

    int getID() const { return id; }

    // Given entity's current facing and frame, return which graphic
    // should be shown and the offset to display it at. NB can return
    // graphic==0 in which case the overlay should not be drawn at
    // all.
    void getGraphic(MapDirection facing, int frame, const Graphic *&gfx, int &ofsx, int &ofsy) const;

    // set functions. called by KnightsConfigImpl.
    void setRawGraphic(MapDirection d, const Graphic *g);
    void setOffset(MapDirection facing, int frame, MapDirection new_dir, int ofsx, int ofsy);

    enum { N_OVERLAY_FRAME = 5 };

    // serialization
    explicit Overlay(int id_, Coercri::InputByteBuf &buf, const std::vector<const Graphic *> &graphics);
    void serialize(Coercri::OutputByteBuf &buf) const;
    
private:
    int id;
    const Graphic *raw_graphic[4];

    struct OffsetData {
        int ofsx;
        int ofsy;
        MapDirection dir;
    };
    OffsetData offset_data[N_OVERLAY_FRAME*4];
};

#endif
