/*
 * menu_selections.hpp
 *
 * Represents the currently selected menu settings
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MENU_SELECTIONS_HPP
#define MENU_SELECTIONS_HPP

#include <map>
#include <string>
#include <vector>

class MenuSelections {
public:
    // Allow direct access to the settings map
    struct Sel {
        int value;
        std::vector<int> allowed_values;
    };
    std::map<std::string, Sel> selections;

    // Also provide functions for more convenient access
    int getValue(const std::string &key) const;
    void setValue(const std::string &key, int new_value);
    void setAllowedValues(const std::string &key, const std::vector<int> &allowed_values);
    std::vector<int> getAllowedValues(const std::string &key) const;
};

#endif
