/*
 * menu_item.hpp
 *
 * Represents a single setting in the quest menu (e.g. "Amount of Stuff")
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MENU_ITEM_HPP
#define MENU_ITEM_HPP

#include "network/byte_buf.hpp"  // coercri

#include <string>
#include <vector>

class MenuItem {
public:
    // menu items have a string key, and a numeric value between min_value
    // and min_value + num_values - 1 (inclusive).
    const std::string & getKey() const { return key; }
    int getMinValue() const { return min_value; }
    int getNumValues() const { return int(value_str.size()); }

    // presentation
    const std::string & getTitleString() const { return title_str; }
    const std::string & getValueString(int i) const { return value_str.at(i - min_value); }
    bool getSpaceAfter() const { return space_after; }
    
    // construction
    MenuItem(const std::string &key_, int min_value_, int nvalues,
             const std::string &title)
        : key(key_), min_value(min_value_),
          title_str(title), value_str(nvalues), space_after(false)  { }
    void setValueString(int val, const std::string &str) { value_str.at(val - min_value) = str; }
    void setSpaceAfter() { space_after = true; }
    
    // serialization
    explicit MenuItem(Coercri::InputByteBuf &buf);
    void serialize(Coercri::OutputByteBuf &buf) const;

private:
    std::string key;
    int min_value;
    std::string title_str;
    std::vector<std::string> value_str;
    bool space_after;
};

#endif
