/*
 * menu.hpp
 *
 * Quest Selection menu.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MENU_HPP
#define MENU_HPP

#include "menu_item.hpp"

#include "network/byte_buf.hpp" // coercri

#include <vector>

class Menu {
public:
    Menu() { }

    // get
    int getNumItems() const { return int(items.size()); }
    const MenuItem & getItem(int i) const { return items[i]; }

    // set
    void addItem(const MenuItem &mi) { items.push_back(mi); }
    MenuItem & getItem(int i) { return items[i]; }
    
    // serialization
    explicit Menu(Coercri::InputByteBuf &buf);
    void serialize(Coercri::OutputByteBuf &buf) const;
    
private:
    std::vector<MenuItem> items;
};

#endif
