/*
 * user_control.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "graphic.hpp"
#include "protocol.hpp"
#include "user_control.hpp"

UserControl::UserControl(int id_, Coercri::InputByteBuf &buf, const std::vector<const Graphic *> &graphics)
{
    id = id_;
    const int gfx_id = buf.readVarInt();
    menu_graphic = gfx_id == 0 ? 0 : graphics.at(gfx_id - 1);
    const int d = buf.readUbyte();
    if (d > 3) throw ProtocolError("error reading UserControl");
    menu_direction = MapDirection(d);
    tap_priority = buf.readVarInt();
    menu_special = buf.readUbyte();
    continuous = buf.readUbyte() != 0;
}

void UserControl::serialize(Coercri::OutputByteBuf &buf) const
{
    buf.writeVarInt(menu_graphic ? menu_graphic->getID() : 0);
    buf.writeUbyte(menu_direction);
    buf.writeVarInt(tap_priority);
    buf.writeUbyte(menu_special);
    buf.writeUbyte(continuous);
}
