/*
 * menu_selections.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "menu_selections.hpp"

int MenuSelections::getValue(const std::string &key) const
{
    std::map<std::string, Sel>::const_iterator it = selections.find(key);
    if (it == selections.end()) return 0;
    else return it->second.value;
}

void MenuSelections::setValue(const std::string &key, int new_value)
{
    selections[key].value = new_value;
}

void MenuSelections::setAllowedValues(const std::string &key, const std::vector<int> &allowed_values)
{
    selections[key].allowed_values = allowed_values;
}

std::vector<int> MenuSelections::getAllowedValues(const std::string &key) const
{
    std::map<std::string, Sel>::const_iterator it = selections.find(key);
    if (it == selections.end()) return std::vector<int>();
    return it->second.allowed_values;
}
