/*
 * menu_item.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "menu_item.hpp"
#include "protocol.hpp"

MenuItem::MenuItem(Coercri::InputByteBuf &buf)
{
    key = buf.readString();
    min_value = buf.readVarInt();
    title_str = buf.readString();
    const int n_vals = buf.readVarInt();
    value_str.resize(n_vals);
    for (int i = 0; i < n_vals; ++i) {
        value_str[i] = buf.readString();
    }
    space_after = buf.readUbyte() != 0;
}

void MenuItem::serialize(Coercri::OutputByteBuf &buf) const
{
    buf.writeString(key);
    buf.writeVarInt(min_value);
    buf.writeString(title_str);
    buf.writeVarInt(value_str.size());
    for (std::vector<std::string>::const_iterator it = value_str.begin(); it != value_str.end(); ++it) {
        buf.writeString(*it);
    }
    buf.writeUbyte(space_after ? 1 : 0);
}
