/*
 * menu.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "menu.hpp"
#include "protocol.hpp"

Menu::Menu(Coercri::InputByteBuf &buf)
{
    const int n_items = buf.readVarInt();
    items.reserve(n_items);
    for (int i = 0; i < n_items; ++i) {
        items.push_back(MenuItem(buf));
    }
}

void Menu::serialize(Coercri::OutputByteBuf &buf) const
{
    buf.writeVarInt(items.size());
    for (std::vector<MenuItem>::const_iterator it = items.begin(); it != items.end(); ++it) {
        it->serialize(buf);
    }
}

        
