/*
 * graphic.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "graphic.hpp"
#include "kfile.hpp"
#include "protocol.hpp"

Graphic::Graphic(const Graphic &rhs)
    : filename(rhs.filename), hx(rhs.hx), hy(rhs.hy), r(rhs.r), g(rhs.g), b(rhs.b), id(rhs.id)
{
    if (rhs.colour_change.get()) {
        colour_change.reset(new ColourChange(*rhs.colour_change));
    }
}

Graphic::Graphic(int id_, Coercri::InputByteBuf &buf)
{
    filename = buf.readString();
    hx = buf.readVarInt();
    hy = buf.readVarInt();
    r = buf.readVarInt();
    g = buf.readVarInt();
    b = buf.readVarInt();
    id = id_;

    bool use_cc = buf.readUbyte() != 0;
    if (use_cc) {
        colour_change.reset(new ColourChange(buf));
    }
}

void Graphic::serialize(Coercri::OutputByteBuf &buf) const
{
    buf.writeString(filename);
    buf.writeVarInt(hx);
    buf.writeVarInt(hy);
    buf.writeVarInt(r);
    buf.writeVarInt(g);
    buf.writeVarInt(b);
    if (colour_change.get()) {
        buf.writeUbyte(1);
        colour_change->serialize(buf);
    } else {
        buf.writeUbyte(0);
    }
}

std::auto_ptr<Graphic> PopGraphic(KConfig::KFile &kf)
{
    KConfig::KFile::List lst(kf, "Graphic", 1, 4, 6);

    lst.push(0);
    std::string filename = kf.popString();
    
    int x = 0, y = 0, r = -1, g = -1, b = -1;
    
    if (lst.getSize() > 1) {
        lst.push(1);
        r = kf.popInt();
        lst.push(2);
        g = kf.popInt();
        lst.push(3);
        b = kf.popInt();
        if (lst.getSize() > 4) {
            lst.push(4);
            x = kf.popInt();
            lst.push(5);
            y = kf.popInt();
        }
    }

    std::auto_ptr<Graphic> gfx(new Graphic(filename, x, y, r, g, b));
    return gfx;
}

