/*
 * anim.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "anim.hpp"
#include "graphic.hpp"
#include "protocol.hpp"

Anim::Anim(int id_, Coercri::InputByteBuf &buf, const std::vector<const Graphic*> &graphics)
{
    for (int i = 0; i < 4; ++i) {
        for (int j = 0; j < NFRAMES; ++j) {
            const int gfx_id = buf.readVarInt();
            g[i][j] = gfx_id == 0 ? 0 : graphics.at(gfx_id-1);
        }
    }

    cc_normal = ColourChange(buf);
    cc_invulnerable = ColourChange(buf);

    id = id_;

    vbat_mode = buf.readUbyte() != 0;
}

void Anim::serialize(Coercri::OutputByteBuf &buf) const
{
    for (int i = 0; i < 4; ++i) {
        for (int j = 0; j < NFRAMES; ++j) {
            const Graphic *gfx = g[i][j];
            buf.writeVarInt(gfx == 0 ? 0 : gfx->getID());
        }
    }

    cc_normal.serialize(buf);
    cc_invulnerable.serialize(buf);
    buf.writeUbyte(vbat_mode);
}
