/*
 * anim.hpp
 *
 * Holds a set of graphics, for different facing directions and
 * animation frames. Used for rendering entities.
 *
 * We also have a special "vbat mode" which is used to do the flapping
 * wings of the vampire bats.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef ANIM_HPP
#define ANIM_HPP

#include "colour_change.hpp"
#include "map_support.hpp"

#include "network/byte_buf.hpp" // coercri

class Graphic;

class Anim {
public:
    explicit Anim(int id_, bool vbat) : id(id_), vbat_mode(vbat)
        { for (int i=0; i<4; ++i) for (int j=0; j<NFRAMES; ++j) g[i][j] = 0; }

    const Graphic * getGraphic(MapDirection facing, int frame) const
        { return g[facing][frame]; }
    const ColourChange & getColourChange(bool invuln) const
        { return invuln ? cc_invulnerable : cc_normal; }
    bool getVbatMode() const
        { return vbat_mode; }
    int getID() const
        { return id; }
    
    void setGraphic(MapDirection d, int frm, const Graphic *g_) 
        { g[d][frm] = g_; }
    void setColourChangeNormal(const ColourChange &cc)
        { cc_normal = cc; }
    void setColourChangeInvulnerable(const ColourChange &cc)
        { cc_invulnerable = cc; }
    void setID(int i)  // called by KnightsConfig
        { id = i; }

    // serialization
    explicit Anim(int id_, Coercri::InputByteBuf &buf, const std::vector<const Graphic *> &graphics);
    void serialize(Coercri::OutputByteBuf &buf) const;
    
private:
    enum { NFRAMES = 8 };
    const Graphic * g[4][NFRAMES]; // 4 facing directions
    ColourChange cc_normal, cc_invulnerable;
    int id;
    bool vbat_mode;
};

// some standard frame numbers
enum AnimFrame { AF_NORMAL=0, AF_BACKSWING=1, AF_IMPACT=2, AF_PARRY=3, AF_THROW_BACK=4, AF_THROW_DOWN=5,
                 AF_XBOW=6, AF_XBOW_LOAD=7 };

#endif
