/*
 * sh_ptr_eq.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SH_PTR_EQ_HPP
#define SH_PTR_EQ_HPP

#include "boost/shared_ptr.hpp"

template<class T>
struct ShPtrEq {
    explicit ShPtrEq(T*p_) : p(p_) { }
    bool operator()(boost::shared_ptr<T> q) const { return p == q.get(); }
    T* p;
};

#endif
